/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.layout.algorithms.AlgorithmHelper;
import org.eclipse.gef4.layout.algorithms.TreeLayoutObserver;

public class TreeLayoutAlgorithm
implements ILayoutAlgorithm {
    public static final int TOP_DOWN = 1;
    public static final int BOTTOM_UP = 2;
    public static final int LEFT_RIGHT = 3;
    public static final int RIGHT_LEFT = 4;
    private int direction = 1;
    private boolean resize = false;
    private ILayoutContext context;
    private Rectangle bounds;
    private double leafSize;
    private double layerSize;
    private TreeLayoutObserver treeObserver;
    private Dimension nodeSpace;

    public TreeLayoutAlgorithm() {
    }

    public TreeLayoutAlgorithm(int direction) {
        this(direction, null);
    }

    public TreeLayoutAlgorithm(int direction, Dimension nodeSpace) {
        this.setDirection(direction);
        this.nodeSpace = nodeSpace;
    }

    public void setNodeSpace(Dimension nodeSpace) {
        this.nodeSpace = nodeSpace;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction != 1 && direction != 2 && direction != 3 && direction != 4) {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
        this.direction = direction;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public void setLayoutContext(ILayoutContext context) {
        if (this.treeObserver != null) {
            this.treeObserver.stop();
        }
        this.context = context;
        if (context != null) {
            this.treeObserver = new TreeLayoutObserver(context, null);
        }
    }

    public ILayoutContext getLayoutContext() {
        return this.context;
    }

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.internalApplyLayout();
        IEntityLayout[] entities = this.context.getEntities();
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        this.scaleEntities(entities);
    }

    private void scaleEntities(IEntityLayout[] entities) {
        if (this.nodeSpace == null) {
            Rectangle bounds2 = new Rectangle(this.bounds);
            int insets = 4;
            bounds2.setX(bounds2.getX() + (double)insets);
            bounds2.setY(bounds2.getY() + (double)insets);
            bounds2.setWidth(bounds2.getWidth() - (double)(2 * insets));
            bounds2.setHeight(bounds2.getHeight() - (double)(2 * insets));
            AlgorithmHelper.fitWithinBounds(entities, bounds2, this.resize);
        }
    }

    void internalApplyLayout() {
        TreeLayoutObserver.TreeNode superRoot = this.treeObserver.getSuperRoot();
        this.bounds = LayoutProperties.getBounds(this.context);
        this.updateLeafAndLayerSizes();
        int leafCountSoFar = 0;
        for (TreeLayoutObserver.TreeNode rootInfo : superRoot.getChildren()) {
            this.computePositionRecursively(rootInfo, leafCountSoFar);
            leafCountSoFar += rootInfo.numOfLeaves;
        }
    }

    private void updateLeafAndLayerSizes() {
        if (this.nodeSpace != null) {
            if (this.getDirection() == 1 || this.getDirection() == 2) {
                this.leafSize = this.nodeSpace.getWidth();
                this.layerSize = this.nodeSpace.getHeight();
            } else {
                this.leafSize = this.nodeSpace.getHeight();
                this.layerSize = this.nodeSpace.getWidth();
            }
        } else {
            TreeLayoutObserver.TreeNode superRoot = this.treeObserver.getSuperRoot();
            if (this.direction == 1 || this.direction == 2) {
                this.leafSize = this.bounds.getWidth() / (double)superRoot.numOfLeaves;
                this.layerSize = this.bounds.getHeight() / (double)superRoot.height;
            } else {
                this.leafSize = this.bounds.getHeight() / (double)superRoot.numOfLeaves;
                this.layerSize = this.bounds.getWidth() / (double)superRoot.height;
            }
        }
    }

    private void computePositionRecursively(TreeLayoutObserver.TreeNode entityInfo, int relativePosition) {
        double breadthPosition = (double)relativePosition + (double)entityInfo.numOfLeaves / 2.0;
        double depthPosition = (double)entityInfo.depth + 0.5;
        switch (this.direction) {
            case 1: {
                LayoutProperties.setLocation(entityInfo.getNode(), breadthPosition * this.leafSize, depthPosition * this.layerSize);
                break;
            }
            case 2: {
                LayoutProperties.setLocation(entityInfo.getNode(), breadthPosition * this.leafSize, this.bounds.getHeight() - depthPosition * this.layerSize);
                break;
            }
            case 3: {
                LayoutProperties.setLocation(entityInfo.getNode(), depthPosition * this.layerSize, breadthPosition * this.leafSize);
                break;
            }
            case 4: {
                LayoutProperties.setLocation(entityInfo.getNode(), this.bounds.getWidth() - depthPosition * this.layerSize, breadthPosition * this.leafSize);
            }
        }
        for (TreeLayoutObserver.TreeNode childInfo : entityInfo.children) {
            this.computePositionRecursively(childInfo, relativePosition);
            relativePosition += childInfo.numOfLeaves;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TreeLayout { direction : ");
        switch (this.direction) {
            case 2: {
                sb.append("bottom -> top");
                break;
            }
            case 3: {
                sb.append("left -> right");
                break;
            }
            case 4: {
                sb.append("right -> left");
                break;
            }
            case 1: {
                sb.append("top -> down");
            }
        }
        sb.append(", resize : " + this.resize);
        sb.append(" }");
        return sb.toString();
    }
}

