/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.ui.parts.IFXCanvasFactory;
import org.eclipse.gef4.mvc.fx.ui.parts.SelectionForwarder;
import org.eclipse.gef4.mvc.fx.ui.viewer.FXCanvasSceneContainer;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.fx.viewer.ISceneContainer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetPage;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class FXView
extends ViewPart {
    @Inject
    private FXDomain domain;
    @Inject
    private IFXCanvasFactory canvasFactory;
    @Inject(optional=true)
    private ISelectionProvider selectionProvider;
    private SelectionForwarder<Node> selectionForwarder;
    private FXCanvas canvas = null;
    private UndoRedoActionGroup undoRedoActionGroup;
    private IPropertySheetPage propertySheetPage;

    public FXView(Injector injector) {
        injector.injectMembers((Object)this);
    }

    protected FXCanvas createCanvas(Composite parent) {
        return this.canvasFactory.createCanvas(parent);
    }

    public void createPartControl(Composite parent) {
        this.canvas = this.createCanvas(parent);
        FXViewer viewer = (FXViewer)this.domain.getAdapter(IViewer.class);
        viewer.setSceneContainer((ISceneContainer)new FXCanvasSceneContainer(this.canvas));
        this.domain.activate();
        ((ContentModel)viewer.getAdapter(ContentModel.class)).setContents(this.getContents());
        if (this.selectionProvider != null) {
            this.selectionForwarder = new SelectionForwarder(this.selectionProvider, this.getViewer());
        }
    }

    public void dispose() {
        if (this.selectionForwarder != null) {
            this.selectionForwarder.dispose();
            this.selectionForwarder = null;
        }
        this.domain.deactivate();
        this.domain.dispose();
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (ISelectionProvider.class.equals((Object)key)) {
            return this.selectionProvider;
        }
        if (IPropertySheetPage.class.equals((Object)key)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new UndoablePropertySheetPage((IOperationHistory)this.getAdapter(IOperationHistory.class), (IUndoContext)this.getAdapter(IUndoContext.class), (UndoRedoActionGroup)this.getAdapter(UndoRedoActionGroup.class));
            }
            return this.propertySheetPage;
        }
        if (UndoRedoActionGroup.class.equals((Object)key)) {
            if (this.undoRedoActionGroup == null) {
                this.undoRedoActionGroup = new UndoRedoActionGroup(this.getSite(), (IUndoContext)this.getAdapter(IUndoContext.class), true);
            }
            return this.undoRedoActionGroup;
        }
        if (IUndoContext.class.equals((Object)key)) {
            return this.domain.getUndoContext();
        }
        if (IOperationHistory.class.equals((Object)key)) {
            return this.domain.getOperationHistory();
        }
        return super.getAdapter(key);
    }

    protected FXCanvas getCanvas() {
        return this.canvas;
    }

    protected abstract List<? extends Object> getContents();

    protected FXDomain getDomain() {
        return this.domain;
    }

    protected FXViewer getViewer() {
        return (FXViewer)this.domain.getAdapter(IViewer.class);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        UndoRedoActionGroup undoRedoActionGroup = (UndoRedoActionGroup)this.getAdapter(UndoRedoActionGroup.class);
        if (undoRedoActionGroup != null) {
            undoRedoActionGroup.fillActionBars(site.getActionBars());
        }
        if (this.selectionProvider != null) {
            site.setSelectionProvider(this.selectionProvider);
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }
}

