/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.behaviors;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;

public class FXCursorBehavior
extends AbstractBehavior<Node> {
    public static final String CURSOR_PROVIDER_ROLE = "cursorProvider";
    private boolean inGesture = false;
    private Cursor initialCursor = null;
    private final EventHandler<? super KeyEvent> keyPressedHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            Map key2cursor = (Map)FXCursorBehavior.this.getCursorProvider().get();
            if (key2cursor.containsKey(event.getCode())) {
                FXCursorBehavior.this.changeCursor((Cursor)key2cursor.get(event.getCode()));
            }
        }
    };
    private final EventHandler<? super KeyEvent> keyReleasedHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            FXCursorBehavior.this.restoreInitialCursor();
            ((Node)FXCursorBehavior.this.getHost().getVisual()).pressedProperty().removeListener(FXCursorBehavior.this.pressedListener);
        }
    };
    private final EventHandler<? super MouseEvent> mouseEnteredHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            ((Node)FXCursorBehavior.this.getHost().getVisual()).pressedProperty().removeListener(FXCursorBehavior.this.pressedListener);
            Scene scene = ((Node)FXCursorBehavior.this.getHost().getVisual()).getScene();
            scene.addEventFilter(KeyEvent.KEY_PRESSED, FXCursorBehavior.this.keyPressedHandler);
            scene.addEventFilter(KeyEvent.KEY_RELEASED, FXCursorBehavior.this.keyReleasedHandler);
            Provider<Map<KeyCode, Cursor>> cursorProvider = FXCursorBehavior.this.getCursorProvider();
            Map key2cursor = (Map)cursorProvider.get();
            FXCursorBehavior.this.setNewCursor(event.isAltDown(), event.isControlDown(), event.isMetaDown(), event.isShiftDown(), event.isShortcutDown(), key2cursor, scene);
        }
    };
    private final ChangeListener<Boolean> pressedListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldPressed, Boolean newPressed) {
            if (!newPressed.booleanValue()) {
                ((Node)FXCursorBehavior.this.getHost().getVisual()).pressedProperty().removeListener(FXCursorBehavior.this.pressedListener);
                if (!((Node)FXCursorBehavior.this.getHost().getVisual()).isHover()) {
                    FXCursorBehavior.this.restoreInitialCursor();
                    Scene scene = ((Node)FXCursorBehavior.this.getHost().getVisual()).getScene();
                    scene.removeEventFilter(KeyEvent.KEY_PRESSED, FXCursorBehavior.this.keyPressedHandler);
                    scene.removeEventFilter(KeyEvent.KEY_RELEASED, FXCursorBehavior.this.keyReleasedHandler);
                }
            }
        }
    };
    private final EventHandler<? super MouseEvent> mouseExitedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (((Node)FXCursorBehavior.this.getHost().getVisual()).isPressed()) {
                ((Node)FXCursorBehavior.this.getHost().getVisual()).pressedProperty().addListener(FXCursorBehavior.this.pressedListener);
            } else {
                FXCursorBehavior.this.restoreInitialCursor();
                Scene scene = ((Node)FXCursorBehavior.this.getHost().getVisual()).getScene();
                scene.removeEventFilter(KeyEvent.KEY_PRESSED, FXCursorBehavior.this.keyPressedHandler);
                scene.removeEventFilter(KeyEvent.KEY_RELEASED, FXCursorBehavior.this.keyReleasedHandler);
            }
        }
    };

    public void activate() {
        super.activate();
        Node visual = (Node)this.getHost().getVisual();
        visual.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredHandler);
        visual.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedHandler);
    }

    protected void changeCursor(Cursor cursor) {
        Scene scene = ((Node)this.getHost().getVisual()).getScene();
        if (!this.inGesture) {
            this.inGesture = true;
            this.initialCursor = scene.getCursor();
        }
        scene.setCursor(cursor);
        FXUtils.forceCursorUpdate((Scene)scene);
    }

    public void deactivate() {
        this.restoreInitialCursor();
        Node visual = (Node)this.getHost().getVisual();
        visual.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredHandler);
        visual.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedHandler);
        Scene scene = ((Node)this.getHost().getVisual()).getScene();
        scene.removeEventFilter(KeyEvent.KEY_PRESSED, this.keyPressedHandler);
        scene.removeEventFilter(KeyEvent.KEY_RELEASED, this.keyReleasedHandler);
        ((Node)this.getHost().getVisual()).pressedProperty().removeListener(this.pressedListener);
        super.deactivate();
    }

    protected Provider<Map<KeyCode, Cursor>> getCursorProvider() {
        return (Provider)this.getHost().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Map<KeyCode, Cursor>>>(){}, (String)CURSOR_PROVIDER_ROLE));
    }

    protected void restoreInitialCursor() {
        this.inGesture = false;
        Scene scene = ((Node)this.getHost().getVisual()).getScene();
        scene.setCursor(this.initialCursor);
        FXUtils.forceCursorUpdate((Scene)scene);
    }

    private void setNewCursor(boolean isAltDown, boolean isControlDown, boolean isMetaDown, boolean isShiftDown, boolean isShortcutDown, Map<KeyCode, Cursor> key2cursor, Scene scene) {
        Cursor cursor = null;
        if (isAltDown && key2cursor.containsKey(KeyCode.ALT)) {
            cursor = key2cursor.get(KeyCode.ALT);
        } else if (isControlDown && key2cursor.containsKey(KeyCode.CONTROL)) {
            cursor = key2cursor.get(KeyCode.CONTROL);
        } else if (isMetaDown && key2cursor.containsKey(KeyCode.META)) {
            cursor = key2cursor.get(KeyCode.META);
        } else if (isShiftDown && key2cursor.containsKey(KeyCode.SHIFT)) {
            cursor = key2cursor.get(KeyCode.SHIFT);
        } else if (isShortcutDown && key2cursor.containsKey(KeyCode.SHORTCUT)) {
            cursor = key2cursor.get(KeyCode.SHORTCUT);
        }
        if (cursor != null) {
            this.changeCursor(cursor);
        }
    }
}

