/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.scene.Node;
import javafx.scene.transform.Scale;
import org.eclipse.gef4.fx.nodes.FXGridLayer;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.ViewportModel;

public class FXGridBehavior
extends AbstractBehavior<Node>
implements PropertyChangeListener {
    private boolean isListeningOnViewport = false;

    public void activate() {
        super.activate();
        GridModel gridModel = (GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class);
        gridModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.applyShowGrid(gridModel.isShowGrid());
        this.applyZoomGrid(gridModel.isZoomGrid());
        this.applyGridCellWidth(gridModel.getGridCellWidth());
        this.applyGridCellHeight(gridModel.getGridCellHeight());
    }

    protected void applyContentsTransform(AffineTransform contentsTransform) {
        double sx = contentsTransform.getScaleX();
        double sy = contentsTransform.getScaleY();
        this.getGridLayer().gridScaleProperty().set((Object)new Scale(sx, sy));
    }

    protected void applyGridCellHeight(double height) {
        this.getGridLayer().setGridHeight(height);
    }

    protected void applyGridCellWidth(double width) {
        this.getGridLayer().setGridWidth(width);
    }

    protected void applyShowGrid(boolean showGrid) {
        if (showGrid) {
            this.getGridLayer().setVisible(true);
            this.getGridLayer().setManaged(true);
        } else {
            this.getGridLayer().setVisible(false);
            this.getGridLayer().setManaged(false);
        }
    }

    protected void applyZoomGrid(boolean zoomGrid) {
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        if (zoomGrid) {
            if (!this.isListeningOnViewport) {
                viewportModel.addPropertyChangeListener((PropertyChangeListener)this);
                this.isListeningOnViewport = true;
                this.applyContentsTransform(viewportModel.getContentsTransform());
            }
        } else if (this.isListeningOnViewport) {
            viewportModel.removePropertyChangeListener((PropertyChangeListener)this);
            this.isListeningOnViewport = false;
            this.getGridLayer().gridScaleProperty().set((Object)new Scale(1.0, 1.0));
        }
    }

    public void deactivate() {
        ((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)).removePropertyChangeListener((PropertyChangeListener)this);
        if (this.isListeningOnViewport) {
            ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
            viewportModel.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.deactivate();
    }

    protected FXGridLayer getGridLayer() {
        return ((FXViewer)this.getHost().getRoot().getViewer()).getGridLayer();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("showGrid".equals(evt.getPropertyName())) {
            this.applyShowGrid((Boolean)evt.getNewValue());
        } else if ("gridCellWidth".equals(evt.getPropertyName())) {
            this.applyGridCellWidth((Double)evt.getNewValue());
        } else if ("gridCellHeight".equals(evt.getPropertyName())) {
            this.applyGridCellHeight((Double)evt.getNewValue());
        } else if ("viewportContentsTransform".equals(evt.getPropertyName())) {
            this.applyContentsTransform((AffineTransform)evt.getNewValue());
        }
    }
}

