/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.fx.nodes.ScrollPaneEx;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ViewportModel;

public class FXViewportBehavior
extends AbstractBehavior<Node>
implements PropertyChangeListener {
    protected final Affine contentsTx = new Affine();
    private ViewportModel viewportModel;
    private final ChangeListener<Number> translateXListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (!FXViewportBehavior.this.inApplyViewport) {
                FXViewportBehavior.this.viewportModel.setTranslateX(newValue.doubleValue());
            }
        }
    };
    private final ChangeListener<Number> translateYListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (!FXViewportBehavior.this.inApplyViewport) {
                FXViewportBehavior.this.viewportModel.setTranslateY(newValue.doubleValue());
            }
        }
    };
    private final ChangeListener<Number> widthListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldWidth, Number newWidth) {
            if (!FXViewportBehavior.this.inApplyViewport) {
                FXViewportBehavior.this.viewportModel.setWidth(newWidth.doubleValue());
            }
        }
    };
    private final ChangeListener<Number> heightListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldHeight, Number newHeight) {
            if (!FXViewportBehavior.this.inApplyViewport) {
                FXViewportBehavior.this.viewportModel.setHeight(newHeight.doubleValue());
            }
        }
    };
    boolean inApplyViewport = false;

    public void activate() {
        super.activate();
        this.viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        this.viewportModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.getScrollPane().widthProperty().addListener(this.widthListener);
        this.getScrollPane().heightProperty().addListener(this.heightListener);
        this.getScrollPane().getScrolledPane().translateXProperty().addListener(this.translateXListener);
        this.getScrollPane().getScrolledPane().translateYProperty().addListener(this.translateYListener);
    }

    protected void applyViewport(double translateX, double translateY, double width, double height, AffineTransform contentsTransform) {
        this.inApplyViewport = true;
        this.getScrollPane().setScrollOffsetX(translateX);
        this.getScrollPane().setScrollOffsetY(translateY);
        this.getScrollPane().setPrefWidth(width);
        this.getScrollPane().setPrefHeight(height);
        this.setTx(this.contentsTx, contentsTransform);
        this.getScrollPane().setViewportTransform(this.contentsTx);
        this.inApplyViewport = false;
    }

    public void deactivate() {
        this.viewportModel.removePropertyChangeListener((PropertyChangeListener)this);
        this.getScrollPane().widthProperty().removeListener(this.widthListener);
        this.getScrollPane().heightProperty().removeListener(this.heightListener);
        this.getScrollPane().getScrolledPane().translateXProperty().removeListener(this.translateXListener);
        this.getScrollPane().getScrolledPane().translateYProperty().removeListener(this.translateYListener);
        super.deactivate();
    }

    protected ScrollPaneEx getScrollPane() {
        return ((FXViewer)this.getHost().getRoot().getViewer()).getScrollPane();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("viewportTranslateX".equals(evt.getPropertyName()) || "viewportTranslateY".equals(evt.getPropertyName()) || "viewportWidth".equals(evt.getPropertyName()) || "viewportHeight".equals(evt.getPropertyName()) || "viewportContentsTransform".equals(evt.getPropertyName())) {
            this.applyViewport(this.viewportModel.getTranslateX(), this.viewportModel.getTranslateY(), this.viewportModel.getWidth(), this.viewportModel.getHeight(), this.viewportModel.getContentsTransform());
        }
    }

    protected void setTx(Affine tx, AffineTransform at) {
        double[] m = at.getMatrix();
        tx.setMxx(m[0]);
        tx.setMxy(m[1]);
        tx.setMyx(m[2]);
        tx.setMyy(m[3]);
        tx.setTx(m[4]);
        tx.setTy(m[5]);
    }
}

