/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.nodes.FXConnection;

public class FXBendOperation
extends AbstractOperation {
    private final FXConnection connection;
    private final List<IFXAnchor> oldAnchors;
    private List<IFXAnchor> newAnchors;

    public FXBendOperation(FXConnection connection) {
        super("Bend");
        this.connection = connection;
        this.oldAnchors = new ArrayList<IFXAnchor>(connection.getAnchors());
        this.newAnchors = new ArrayList<IFXAnchor>(this.oldAnchors);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.connection != null) {
            this.connection.setAnchors(this.newAnchors);
        }
        return Status.OK_STATUS;
    }

    public FXConnection getConnection() {
        return this.connection;
    }

    public List<IFXAnchor> getNewAnchors() {
        return this.newAnchors;
    }

    public List<IFXAnchor> getOldAnchors() {
        return this.oldAnchors;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setNewAnchors(List<IFXAnchor> newAnchors) {
        this.newAnchors = newAnchors;
    }

    public String toString() {
        return "FXBendOperation";
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.connection != null) {
            this.connection.setAnchors(this.oldAnchors);
        }
        return Status.OK_STATUS;
    }
}

