/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.anchors.FXChopBoxAnchor;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.HoverBehavior;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXHoverFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXSelectionFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXSelectionLinkFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXDefaultFeedbackPartFactory
implements IFeedbackPartFactory<Node> {
    public static final String SELECTION_FEEDBACK_GEOMETRY_PROVIDER = "SELECTION_FEEDBACK_GEOMETRY_PROVIDER";
    public static final String SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER = "SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER";
    public static final String HOVER_FEEDBACK_GEOMETRY_PROVIDER = "HOVER_FEEDBACK_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    public List<IFeedbackPart<Node, ? extends Node>> createFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            return Collections.emptyList();
        }
        if (contextBehavior instanceof SelectionBehavior) {
            return this.createSelectionFeedbackParts(targets, (SelectionBehavior<Node>)((SelectionBehavior)contextBehavior), contextMap);
        }
        if (contextBehavior instanceof HoverBehavior) {
            return this.createHoverFeedbackParts(targets, (HoverBehavior<Node>)((HoverBehavior)contextBehavior), contextMap);
        }
        return Collections.emptyList();
    }

    protected List<IFeedbackPart<Node, ? extends Node>> createHoverFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, HoverBehavior<Node> hoverBehavior, Map<Object, Object> contextMap) {
        if (targets.size() == 0 || targets.size() > 1) {
            return Collections.emptyList();
        }
        ArrayList<IFeedbackPart<Node, ? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<Node, ? extends Node>>();
        final IVisualPart<Node, ? extends Node> target = targets.iterator().next();
        final Provider hoverFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)HOVER_FEEDBACK_GEOMETRY_PROVIDER));
        if (hoverFeedbackGeometryProvider != null) {
            Provider<IGeometry> geometryInSceneProvider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return FXUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)hoverFeedbackGeometryProvider.get()));
                }
            };
            FXHoverFeedbackPart part = new FXHoverFeedbackPart((Provider<? extends IGeometry>)geometryInSceneProvider);
            this.injector.injectMembers((Object)part);
            feedbackParts.add((IFeedbackPart<Node, ? extends Node>)part);
        }
        return feedbackParts;
    }

    protected IFeedbackPart<Node, ? extends Node> createLinkFeedbackPart(final IVisualPart<Node, ? extends Node> anchored, final IVisualPart<Node, ? extends Node> anchorage, String anchorageRole) {
        if (!(anchored.getVisual() instanceof FXConnection)) {
            final Provider anchorageGeometryProvider = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER));
            final Provider anchoredGeometryProvider = (Provider)anchored.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER));
            if (anchoredGeometryProvider != null && anchorageGeometryProvider != null) {
                if (anchoredGeometryProvider == null || anchorageGeometryProvider == null) {
                    return null;
                }
                Provider<IGeometry> linkFeedbackGeometryProvider = new Provider<IGeometry>(){
                    private final FXChopBoxAnchor.ComputationStrategy.Impl computationStrategy = new FXChopBoxAnchor.ComputationStrategy.Impl();

                    private Point computePosition(Node anchoredVisual, IGeometry anchoredGeometryInLocal, Node anchorageVisual, IGeometry anchorageGeometryInLocal) {
                        return this.computationStrategy.computePositionInScene(anchorageVisual, anchoredVisual, this.computationStrategy.computeAnchorageReferencePointInLocal(anchoredVisual, anchoredGeometryInLocal));
                    }

                    public IGeometry get() {
                        Node anchoredVisual = (Node)anchored.getVisual();
                        IGeometry anchoredGeometryInLocal = (IGeometry)anchoredGeometryProvider.get();
                        Node anchorageVisual = (Node)anchorage.getVisual();
                        IGeometry anchorageGeometryInLocal = (IGeometry)anchorageGeometryProvider.get();
                        Point sourcePointInScene = this.computePosition(anchoredVisual, anchoredGeometryInLocal, anchorageVisual, anchorageGeometryInLocal);
                        Point targetPointInScene = this.computePosition(anchorageVisual, anchorageGeometryInLocal, anchoredVisual, anchoredGeometryInLocal);
                        return new Line(sourcePointInScene, targetPointInScene);
                    }
                };
                return new FXSelectionLinkFeedbackPart(linkFeedbackGeometryProvider);
            }
        }
        return null;
    }

    protected List<IFeedbackPart<Node, ? extends Node>> createSelectionFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, SelectionBehavior<Node> selectionBehavior, Map<Object, Object> contextMap) {
        if (targets.size() == 0 || targets.size() > 1) {
            return Collections.emptyList();
        }
        ArrayList<IFeedbackPart<Node, ? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<Node, ? extends Node>>();
        final IVisualPart<Node, ? extends Node> target = targets.iterator().next();
        final Provider selectionFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_FEEDBACK_GEOMETRY_PROVIDER));
        if (selectionFeedbackGeometryProvider != null) {
            Provider<IGeometry> provider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return FXUtils.localToScene((Node)((Node)target.getVisual()), (IGeometry)((IGeometry)selectionFeedbackGeometryProvider.get()));
                }
            };
            FXSelectionFeedbackPart selectionFeedbackPart = new FXSelectionFeedbackPart(provider);
            this.injector.injectMembers((Object)selectionFeedbackPart);
            feedbackParts.add((IFeedbackPart<Node, ? extends Node>)selectionFeedbackPart);
        }
        for (IVisualPart<Node, ? extends Node> iVisualPart : targets) {
            if (iVisualPart.getAnchorages().isEmpty()) continue;
            for (Map.Entry entry : iVisualPart.getAnchorages().entries()) {
                IFeedbackPart<Node, ? extends Node> anchorLinkFeedbackPart;
                if (!(entry.getKey() instanceof IVisualPart) || (anchorLinkFeedbackPart = this.createLinkFeedbackPart(iVisualPart, (IVisualPart<Node, ? extends Node>)((IVisualPart)entry.getKey()), (String)entry.getValue())) == null) continue;
                this.injector.injectMembers(anchorLinkFeedbackPart);
                feedbackParts.add(anchorLinkFeedbackPart);
            }
        }
        return feedbackParts;
    }
}

