/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import java.util.Collection;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXPartUtils {
    public static <T extends IPolicy<Node>> IVisualPart<Node, ? extends Node> getTargetPart(Collection<IViewer<Node>> viewers, Node visual, Class<T> supportedPolicy, boolean searchHierarchy) {
        for (IViewer<Node> viewer : viewers) {
            Node rootVisual = (Node)viewer.getRootPart().getVisual();
            Node targetNode = visual;
            IVisualPart targetPart = (IVisualPart)viewer.getVisualPartMap().get(targetNode);
            while (targetNode != null && (targetPart == null || searchHierarchy && supportedPolicy != null && targetPart.getAdapters(supportedPolicy).isEmpty()) && targetNode != rootVisual) {
                targetNode = targetNode.getParent();
                targetPart = (IVisualPart)viewer.getVisualPartMap().get(targetNode);
            }
            if (targetPart == null) continue;
            if (supportedPolicy == null) {
                return targetPart;
            }
            if (!targetPart.getAdapters(supportedPolicy).isEmpty()) {
                return targetPart;
            }
            return null;
        }
        return null;
    }

    public static Rectangle getUnionedVisualBoundsInScene(Collection<? extends IVisualPart<Node, ? extends Node>> parts) {
        Rectangle bounds = null;
        for (IVisualPart<Node, ? extends Node> iVisualPart : parts) {
            Rectangle boundsInScene = JavaFX2Geometry.toRectangle((Bounds)((Node)iVisualPart.getVisual()).localToScene(((Node)iVisualPart.getVisual()).getLayoutBounds()));
            if (bounds == null) {
                bounds = boundsInScene;
                continue;
            }
            bounds.union(boundsInScene);
        }
        return bounds;
    }
}

