/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.inject.Provider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXSelectionFeedbackPart
extends AbstractFXFeedbackPart<FXGeometryNode<IGeometry>> {
    private final PropertyChangeListener focusModelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ViewerFocus".equals(evt.getPropertyName())) {
                FXSelectionFeedbackPart.this.refreshVisual();
            } else if ("focus".equals(evt.getPropertyName())) {
                FXSelectionFeedbackPart.this.refreshVisual();
            }
        }
    };
    private final Provider<IGeometry> feedbackGeometryProvider;
    private static final Color FOCUS_COLOR = Color.rgb((int)125, (int)173, (int)217);

    public FXSelectionFeedbackPart(Provider<IGeometry> feedbackGeometryProvider) {
        this.feedbackGeometryProvider = feedbackGeometryProvider;
    }

    protected FXGeometryNode<IGeometry> createVisual() {
        FXGeometryNode feedbackVisual = new FXGeometryNode();
        feedbackVisual.setFill((Paint)Color.TRANSPARENT);
        feedbackVisual.setMouseTransparent(true);
        feedbackVisual.setManaged(false);
        feedbackVisual.setStrokeWidth(1.0);
        return feedbackVisual;
    }

    protected void doActivate() {
        super.doActivate();
        ((FocusModel)this.getRoot().getViewer().getAdapter(FocusModel.class)).addPropertyChangeListener(this.focusModelListener);
    }

    protected void doDeactivate() {
        ((FocusModel)this.getRoot().getViewer().getAdapter(FocusModel.class)).removePropertyChangeListener(this.focusModelListener);
        super.doDeactivate();
    }

    public void doRefreshVisual(FXGeometryNode<IGeometry> visual) {
        boolean primary;
        Set anchorages = this.getAnchorages().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        IVisualPart anchorage = (IVisualPart)anchorages.iterator().next();
        IViewer viewer = anchorage.getRoot().getViewer();
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
        boolean focused = ((FocusModel)viewer.getAdapter(FocusModel.class)).isViewerFocused() && ((FocusModel)viewer.getAdapter(FocusModel.class)).getFocused() == anchorage;
        List selected = ((SelectionModel)viewer.getAdapter(SelectionModel.class)).getSelected();
        boolean bl = primary = selected.get(0) == anchorage;
        if (primary) {
            visual.setEffect(this.getPrimarySelectionFeedbackEffect(focused));
            visual.setStroke((Paint)Color.BLACK);
        } else {
            visual.setEffect(this.getSecondarySelectionFeedbackEffect(focused));
            visual.setStroke((Paint)Color.GREY);
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return FXUtils.sceneToLocal((Node)((Node)this.getVisual()), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    protected Effect getPrimarySelectionFeedbackEffect(boolean focused) {
        DropShadow effect = new DropShadow();
        effect.setColor(focused ? FOCUS_COLOR : Color.GREY);
        effect.setRadius(5.0);
        effect.setSpread(0.6);
        return effect;
    }

    protected Effect getSecondarySelectionFeedbackEffect(boolean focused) {
        DropShadow effect = new DropShadow();
        effect.setColor(focused ? FOCUS_COLOR : Color.GREY);
        effect.setRadius(5.0);
        effect.setSpread(0.6);
        return effect;
    }
}

