/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.convert.fx.Geometry2JavaFX;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXResizeRelocatePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;

public class FXRelocateOnDragPolicy
extends AbstractFXOnDragPolicy {
    private Point initialMouseLocationInScene = null;

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        for (IContentPart<Node, ? extends Node> part : this.getTargetParts()) {
            FXResizeRelocatePolicy policy = this.getResizeRelocatePolicy(part);
            if (policy == null) continue;
            Node visual = (Node)part.getVisual();
            Point2D initialPosInParent = visual.localToParent(visual.sceneToLocal(Geometry2JavaFX.toFXPoint((Point)this.getInitialMouseLocationInScene())));
            Point2D currentPosInParent = visual.localToParent(visual.sceneToLocal(e.getSceneX(), e.getSceneY()));
            Point2D deltaPoint = new Point2D(currentPosInParent.getX() - initialPosInParent.getX(), currentPosInParent.getY() - initialPosInParent.getY());
            policy.performResizeRelocate(deltaPoint.getX(), deltaPoint.getY(), 0.0, 0.0);
        }
    }

    protected Point getInitialMouseLocationInScene() {
        return this.initialMouseLocationInScene;
    }

    protected FXResizeRelocatePolicy getResizeRelocatePolicy(IContentPart<Node, ? extends Node> part) {
        return (FXResizeRelocatePolicy)((Object)part.getAdapter(FXResizeRelocatePolicy.class));
    }

    public List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelected();
    }

    @Override
    public void press(MouseEvent e) {
        this.setInitialMouseLocationInScene(new Point(e.getSceneX(), e.getSceneY()));
        for (IContentPart<Node, ? extends Node> part : this.getTargetParts()) {
            this.disableRefreshVisuals((IVisualPart)part);
            part.setRefreshVisual(false);
            this.init((IPolicy)this.getResizeRelocatePolicy(part));
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        for (IContentPart<Node, ? extends Node> part : this.getTargetParts()) {
            FXResizeRelocatePolicy policy = this.getResizeRelocatePolicy(part);
            if (policy == null) continue;
            this.enableRefreshVisuals((IVisualPart)part);
            this.commit((IPolicy)policy);
        }
        this.setInitialMouseLocationInScene(null);
    }

    protected void setInitialMouseLocationInScene(Point point) {
        this.initialMouseLocationInScene = point;
    }
}

