/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXResizeRelocatePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;

public class FXResizeRelocateOnHandleDragPolicy
extends AbstractFXOnDragPolicy {
    private Point initialPointerLocation;
    private double initialTx;
    private double initialTy;
    private double dx;
    private double dy;
    private double dw;
    private double dh;
    private boolean invalidGesture = false;

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        this.updateDeltas(e);
        this.getResizeRelocatePolicy().performResizeRelocate(this.dx, this.dy, this.dw, this.dh);
    }

    public AbstractFXSegmentHandlePart<? extends Node> getHost() {
        return (AbstractFXSegmentHandlePart)super.getHost();
    }

    protected FXResizeRelocatePolicy getResizeRelocatePolicy() {
        return (FXResizeRelocatePolicy)((Object)this.getTargetPart().getAdapter(FXResizeRelocatePolicy.class));
    }

    protected IVisualPart<Node, ? extends Node> getTargetPart() {
        return (IVisualPart)this.getHost().getAnchorages().keySet().iterator().next();
    }

    private Affine getTargetTransform() {
        return (Affine)((Provider)this.getTargetPart().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Affine>>(){}, (String)"transformationProvider"))).get();
    }

    private boolean isMultiSelection() {
        return ((SelectionModel)this.getTargetPart().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelected().size() > 1;
    }

    @Override
    public void press(MouseEvent e) {
        if (e.isControlDown() || this.isMultiSelection()) {
            this.invalidGesture = true;
            return;
        }
        this.initialPointerLocation = new Point(e.getSceneX(), e.getSceneY());
        this.initialTx = this.getTargetTransform().getTx();
        this.initialTy = this.getTargetTransform().getTy();
        this.init((IPolicy)this.getResizeRelocatePolicy());
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        this.updateDeltas(e);
        this.commit((IPolicy)this.getResizeRelocatePolicy());
    }

    protected void updateDeltas(MouseEvent e) {
        this.dh = 0.0;
        this.dw = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        Node visual = (Node)this.getTargetPart().getVisual();
        Point2D startLocal = visual.sceneToLocal(this.initialPointerLocation.x, this.initialPointerLocation.y);
        Point2D endLocal = visual.sceneToLocal(e.getSceneX(), e.getSceneY());
        double deltaX = endLocal.getX() - startLocal.getX();
        double deltaY = endLocal.getY() - startLocal.getY();
        int segment = this.getHost().getSegmentIndex();
        Point2D layout = visual.parentToLocal(this.initialTx, this.initialTy);
        double lx = layout.getX();
        double ly = layout.getY();
        if (segment == 0 || segment == 3) {
            lx += deltaX;
        }
        if (segment == 0 || segment == 1) {
            ly += deltaY;
        }
        Point2D layoutParent = visual.localToParent(lx, ly);
        this.dx = layoutParent.getX() - this.initialTx;
        this.dy = layoutParent.getY() - this.initialTy;
        this.dw = segment == 1 || segment == 2 ? deltaX : -deltaX;
        this.dh = segment == 2 || segment == 3 ? deltaY : -deltaY;
    }
}

