/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.scene.Node;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.fx.policies.FXResizePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public class FXResizeRelocatePolicy
extends AbstractPolicy<Node>
implements ITransactional {
    public IUndoableOperation commit() {
        FXTransformPolicy transformPolicy;
        IUndoableOperation commit;
        ForwardUndoCompositeOperation fwd = new ForwardUndoCompositeOperation("ResizeRelocate");
        FXResizePolicy resizePolicy = this.getResizePolicy();
        IUndoableOperation iUndoableOperation = commit = resizePolicy == null ? null : resizePolicy.commit();
        if (commit != null) {
            fwd.add(commit);
        }
        IUndoableOperation iUndoableOperation2 = commit = (transformPolicy = this.getTransformPolicy()) == null ? null : transformPolicy.commit();
        if (commit != null) {
            fwd.add(commit);
        }
        return fwd.unwrap();
    }

    protected double getMinimumHeight() {
        return 5.0;
    }

    protected double getMinimumWidth() {
        return 5.0;
    }

    protected FXResizePolicy getResizePolicy() {
        return (FXResizePolicy)((Object)this.getHost().getAdapter(FXResizePolicy.class));
    }

    protected FXTransformPolicy getTransformPolicy() {
        return (FXTransformPolicy)((Object)this.getHost().getAdapter(FXTransformPolicy.class));
    }

    public void init() {
        FXResizePolicy resizePolicy;
        FXTransformPolicy transformPolicy = this.getTransformPolicy();
        if (transformPolicy != null) {
            transformPolicy.init();
        }
        if ((resizePolicy = this.getResizePolicy()) != null) {
            resizePolicy.init();
        }
    }

    public void performResizeRelocate(double dx, double dy, double dw, double dh) {
        FXTransformPolicy transformPolicy;
        FXResizePolicy resizePolicy = this.getResizePolicy();
        if (!((Node)this.getHost().getVisual()).isResizable() || resizePolicy == null) {
            dw = 0.0;
            dh = 0.0;
            dx += dw / 2.0;
            dy += dh / 2.0;
        }
        if (resizePolicy != null) {
            resizePolicy.performResize(dw, dh);
        }
        if ((transformPolicy = this.getTransformPolicy()) != null) {
            transformPolicy.setPreConcatenation(new AffineTransform().setToTranslation(dx, dy));
        }
    }
}

