/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public class FXRotatePolicy
extends AbstractPolicy<Node>
implements ITransactional {
    public IUndoableOperation commit() {
        return this.getTransformPolicy().commit();
    }

    protected FXTransformPolicy getTransformPolicy() {
        return (FXTransformPolicy)((Object)this.getHost().getAdapter(FXTransformPolicy.class));
    }

    public void init() {
        this.getTransformPolicy().init();
    }

    public void performRotation(Angle rotationAngle, Point pivotInScene) {
        Point2D pivotLocal = ((Node)this.getHost().getVisual()).sceneToLocal(pivotInScene.x, pivotInScene.y);
        FXTransformPolicy transformPolicy = this.getTransformPolicy();
        AffineTransform oldTransform = JavaFX2Geometry.toAffineTransform((Transform)transformPolicy.getNodeTransform());
        double scaleX = oldTransform.getScaleX();
        double scaleY = oldTransform.getScaleY();
        this.updateOperation(rotationAngle, new Point(pivotLocal.getX() * scaleX, pivotLocal.getY() * scaleY));
    }

    protected void updateOperation(Angle rotationAngle, Point pivotInHostVisual) {
        FXTransformPolicy transformPolicy = this.getTransformPolicy();
        Affine nodeTransform = transformPolicy.getNodeTransform();
        AffineTransform oldTransform = JavaFX2Geometry.toAffineTransform((Transform)nodeTransform);
        double scaleX = oldTransform.getScaleX();
        double scaleY = oldTransform.getScaleY();
        AffineTransform rotate = new AffineTransform().scale(1.0 / scaleX, 1.0 / scaleY).rotate(rotationAngle.rad(), pivotInHostVisual.x, pivotInHostVisual.y).scale(scaleX, scaleY);
        transformPolicy.setConcatenation(rotate);
    }
}

