/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXRotatePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXRotateSelectedOnHandleDragPolicy
extends AbstractFXOnDragPolicy {
    private boolean invalidGesture = false;
    private Point initialPointerLocationInScene;
    private Point pivotInScene;

    protected Angle computeRotationAngleCW(MouseEvent e, IVisualPart<Node, ? extends Node> part) {
        Vector vStart = new Vector(this.pivotInScene, this.initialPointerLocationInScene);
        Vector vEnd = new Vector(this.pivotInScene, new Point(e.getSceneX(), e.getSceneY()));
        Angle angle = vStart.getAngleCW(vEnd);
        return angle;
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
        }
    }

    protected FXRotatePolicy getRotatePolicy(IVisualPart<Node, ? extends Node> part) {
        return (FXRotatePolicy)((Object)part.getAdapter(FXRotatePolicy.class));
    }

    protected List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelected();
    }

    @Override
    public void press(MouseEvent e) {
        if (!e.isControlDown()) {
            this.invalidGesture = true;
            return;
        }
        this.initialPointerLocationInScene = new Point(e.getSceneX(), e.getSceneY());
        Rectangle bounds = FXPartUtils.getUnionedVisualBoundsInScene(this.getTargetParts());
        this.pivotInScene = bounds == null ? null : bounds.getCenter();
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            FXRotatePolicy rotatePolicy = this.getRotatePolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (rotatePolicy == null) continue;
            rotatePolicy.init();
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
            FXRotatePolicy rotatePolicy = this.getRotatePolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (rotatePolicy == null) continue;
            this.getHost().getRoot().getViewer().getDomain().execute(rotatePolicy.commit());
        }
    }

    private void updateOperation(MouseEvent e, IVisualPart<Node, ? extends Node> part) {
        FXRotatePolicy rotatePolicy = this.getRotatePolicy(part);
        if (rotatePolicy != null) {
            rotatePolicy.performRotation(this.computeRotationAngleCW(e, part), this.pivotInScene);
        }
    }
}

