/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.fx.policies.FXResizePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;

public class FXScaleRelocatePolicy
extends AbstractPolicy<Node>
implements ITransactional {
    private AffineTransform oldTransform;

    public IUndoableOperation commit() {
        ForwardUndoCompositeOperation fwd = new ForwardUndoCompositeOperation("ScaleRelocate");
        fwd.add(this.getResizePolicy().commit());
        fwd.add(this.getTransformPolicy().commit());
        return fwd;
    }

    protected FXResizePolicy getResizePolicy() {
        return (FXResizePolicy)((Object)this.getHost().getAdapter(FXResizePolicy.class));
    }

    protected FXTransformPolicy getTransformPolicy() {
        return (FXTransformPolicy)((Object)this.getHost().getAdapter(FXTransformPolicy.class));
    }

    public void init() {
        this.getTransformPolicy().init();
        this.getResizePolicy().init();
        this.oldTransform = JavaFX2Geometry.toAffineTransform((Transform)this.getTransformPolicy().getNodeTransform());
    }

    public void performScaleRelocate(Bounds oldBoundsInScene, Bounds newBoundsInScene) {
        double sx = newBoundsInScene.getWidth() / oldBoundsInScene.getWidth();
        double sy = newBoundsInScene.getHeight() / oldBoundsInScene.getHeight();
        AffineTransform scale = JavaFX2Geometry.toAffineTransform((Transform)new Scale(sx, sy, 0.0, 0.0));
        double dx = newBoundsInScene.getMinX() - oldBoundsInScene.getMinX();
        double dy = newBoundsInScene.getMinY() - oldBoundsInScene.getMinY();
        Point2D originInParent = ((Node)this.getHost().getVisual()).getParent().sceneToLocal(0.0, 0.0);
        Point2D deltaInParent = ((Node)this.getHost().getVisual()).getParent().sceneToLocal(dx, dy);
        dx = deltaInParent.getX() - originInParent.getX();
        dy = deltaInParent.getY() - originInParent.getY();
        AffineTransform translate = new AffineTransform().setToTranslation(dx, dy);
        this.getTransformPolicy().setTransform(translate.concatenate(this.oldTransform).concatenate(scale));
    }
}

