/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXFocusTool
extends AbstractTool<Node> {
    private final Map<IViewer<Node>, ChangeListener<? super Boolean>> viewerFocusListenerMap = new HashMap<IViewer<Node>, ChangeListener<? super Boolean>>();

    private ChangeListener<? super Boolean> createWindowFocusedChangeListener(final IViewer<Node> viewer) {
        return new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ((FocusModel)viewer.getAdapter(FocusModel.class)).setViewerFocused(newValue.booleanValue());
            }
        };
    }

    protected void registerListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            ChangeListener<? super Boolean> listener = this.createWindowFocusedChangeListener((IViewer<Node>)viewer);
            this.viewerFocusListenerMap.put((IViewer<Node>)viewer, listener);
            ((Window)scene.windowProperty().get()).focusedProperty().addListener(listener);
        }
    }

    protected void unregisterListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            ((Window)scene.windowProperty().get()).focusedProperty().removeListener(this.viewerFocusListenerMap.get(viewer));
        }
    }
}

