/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnHoverPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXHoverTool
extends AbstractTool<Node> {
    public static final Class<AbstractFXOnHoverPolicy> TOOL_POLICY_KEY = AbstractFXOnHoverPolicy.class;
    private final Map<FXViewer, EventHandler<MouseEvent>> hoverFilters = new HashMap<FXViewer, EventHandler<MouseEvent>>();

    protected EventHandler<MouseEvent> createHoverFilter(final FXViewer viewer) {
        return new EventHandler<MouseEvent>(){

            protected Collection<? extends AbstractFXOnHoverPolicy> getTargetPolicies(MouseEvent event) {
                EventTarget target = event.getTarget();
                if (!(target instanceof Node)) {
                    return Collections.emptyList();
                }
                Scene scene = ((Node)target).getScene();
                if (scene == null) {
                    return Collections.emptyList();
                }
                List targetNodes = FXUtils.getNodesAt((Node)scene.getRoot(), (double)event.getSceneX(), (double)event.getSceneY());
                IRootPart targetPart = null;
                int i = 0;
                while (i < targetNodes.size()) {
                    IVisualPart part;
                    Node n = (Node)targetNodes.get(i);
                    if (viewer.getScene() == scene && (part = (IVisualPart)viewer.getVisualPartMap().get(n)) != null) {
                        targetPart = part;
                        break;
                    }
                    ++i;
                }
                if (targetPart == null) {
                    targetPart = viewer.getRootPart();
                }
                Set<? extends AbstractFXOnHoverPolicy> policies = FXHoverTool.this.getHoverPolicies((IVisualPart<Node, ? extends Node>)targetPart);
                return policies;
            }

            public void handle(MouseEvent event) {
                if (!event.getEventType().equals(MouseEvent.MOUSE_MOVED) && !event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
                    return;
                }
                Collection<? extends AbstractFXOnHoverPolicy> policies = this.getTargetPolicies(event);
                for (AbstractFXOnHoverPolicy abstractFXOnHoverPolicy : policies) {
                    abstractFXOnHoverPolicy.hover(event);
                }
            }
        };
    }

    protected Set<? extends AbstractFXOnHoverPolicy> getHoverPolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(TOOL_POLICY_KEY).values());
    }

    protected void registerListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            if (!(viewer instanceof FXViewer)) continue;
            EventHandler<MouseEvent> hoverFilter = this.createHoverFilter((FXViewer)viewer);
            this.hoverFilters.put((FXViewer)viewer, hoverFilter);
            ((Node)viewer.getRootPart().getVisual()).getScene().addEventFilter(MouseEvent.ANY, hoverFilter);
        }
    }

    protected void unregisterListeners() {
        for (Map.Entry<FXViewer, EventHandler<MouseEvent>> e : this.hoverFilters.entrySet()) {
            ((Node)e.getKey().getRootPart().getVisual()).getScene().removeEventFilter(MouseEvent.ANY, e.getValue());
        }
        this.hoverFilters.clear();
    }
}

