/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.models.HoverModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class HoverBehavior<VR>
extends AbstractBehavior<VR>
implements PropertyChangeListener {
    @Override
    public void activate() {
        super.activate();
        HoverModel<VR> hoverModel = this.getHoverModel();
        hoverModel.addPropertyChangeListener(this);
        IVisualPart<VR, VR> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(null, hover);
        }
    }

    @Override
    public void deactivate() {
        HoverModel<VR> hoverModel = this.getHoverModel();
        this.removeFeedback(Collections.singletonList(this.getHost()));
        this.removeHandles(Collections.singletonList(this.getHost()));
        hoverModel.removePropertyChangeListener(this);
        super.deactivate();
    }

    protected HoverModel<VR> getHoverModel() {
        return (HoverModel)this.getHost().getRoot().getViewer().getAdapter(HoverModel.class);
    }

    protected void onHoverChange(IVisualPart<VR, ? extends VR> oldHovered, IVisualPart<VR, ? extends VR> newHovered) {
        if (this.getHost() != oldHovered && this.getHost() == newHovered) {
            this.addFeedback(Collections.singletonList(this.getHost()));
        } else if (this.getHost() == oldHovered && this.getHost() != newHovered) {
            this.removeFeedback(Collections.singletonList(this.getHost()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("hover")) {
            IVisualPart oldHovered = (IVisualPart)event.getOldValue();
            IVisualPart newHovered = (IVisualPart)event.getNewValue();
            this.onHoverChange(oldHovered, newHovered);
        }
    }
}

