/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractCompositeOperation
extends AbstractOperation
implements ICompositeOperation {
    List<IUndoableOperation> operations = new ArrayList<IUndoableOperation>();

    public AbstractCompositeOperation(String label) {
        super(label);
    }

    public void add(IUndoableOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("The given operation may not be null.");
        }
        this.operations.add(operation);
    }

    public void addAll(List<IUndoableOperation> operations) {
        for (IUndoableOperation op : operations) {
            this.add(op);
        }
    }

    public void addContext(IUndoContext context) {
        super.addContext(context);
    }

    public boolean canExecute() {
        for (IUndoableOperation operation : this.operations) {
            if (operation.canExecute()) continue;
            return false;
        }
        return true;
    }

    public boolean canRedo() {
        for (IUndoableOperation operation : this.operations) {
            if (operation.canRedo()) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        for (IUndoableOperation operation : this.operations) {
            if (operation.canUndo()) continue;
            return false;
        }
        return true;
    }

    protected IStatus combine(IStatus s1, IStatus s2) {
        MultiStatus status = new MultiStatus("org.eclipse.gef4.mvc", 0, null, null);
        status.merge(s1);
        status.merge(s2);
        return status;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (IUndoableOperation operation : this.operations) {
            this.combine(status, operation.execute(monitor, info));
        }
        return status;
    }

    public List<IUndoableOperation> getOperations() {
        return this.operations;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (IUndoableOperation operation : this.operations) {
            this.combine(status, operation.redo(monitor, info));
        }
        return status;
    }

    public void remove(IUndoableOperation operation) {
        this.operations.remove(operation);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        for (IUndoableOperation operation : this.operations) {
            this.combine(status, operation.undo(monitor, info));
        }
        return status;
    }

    public IUndoableOperation unwrap() {
        if (this.operations.size() == 0) {
            return null;
        }
        if (this.operations.size() == 1) {
            return this.operations.get(0);
        }
        return this;
    }
}

