/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.common.activate.ActivatableSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdaptableSupport;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.inject.AdaptableScopes;
import org.eclipse.gef4.common.inject.AdapterMap;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractVisualPart<VR, V extends VR>
implements IVisualPart<VR, V> {
    private static final String DEFAULT_ANCHORAGE_ROLE = "default";
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this, this.pcs);
    private AdaptableSupport<IVisualPart<VR, V>> ads = new AdaptableSupport((IAdaptable)this, this.pcs);
    private IVisualPart<VR, ? extends VR> parent;
    private List<IVisualPart<VR, ? extends VR>> children;
    private Multiset<IVisualPart<VR, ? extends VR>> anchoreds;
    private SetMultimap<IVisualPart<VR, ? extends VR>, String> anchorages;
    private boolean refreshVisual = true;
    private V visual;

    public AbstractVisualPart() {
        AdaptableScopes.enter((IAdaptable)this);
    }

    public final void activate() {
        if (!this.acs.isActive()) {
            this.acs.activate();
            this.doActivate();
        }
    }

    @Override
    public void addAnchorage(IVisualPart<VR, ? extends VR> anchorage) {
        this.addAnchorage(anchorage, DEFAULT_ANCHORAGE_ROLE);
    }

    @Override
    public void addAnchorage(IVisualPart<VR, ? extends VR> anchorage, String role) {
        HashMultimap oldAnchorages;
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null.");
        }
        HashMultimap hashMultimap = oldAnchorages = this.anchorages == null ? HashMultimap.create() : HashMultimap.create(this.anchorages);
        if (oldAnchorages.containsEntry(anchorage, (Object)role)) {
            throw new IllegalArgumentException("Already attached to anchorage " + anchorage + " in role '" + role + "'.");
        }
        this.addAnchorageWithoutNotify(anchorage, role);
        anchorage.addAnchored(this);
        anchorage.refreshVisual();
        this.attachToAnchorageVisual(anchorage, role);
        this.refreshVisual();
        this.pcs.firePropertyChange("anchorages", oldAnchorages, this.getAnchorages());
    }

    private void addAnchorageWithoutNotify(IVisualPart<VR, ? extends VR> anchorage, String role) {
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (this.anchorages == null) {
            this.anchorages = HashMultimap.create();
        }
        this.anchorages.put(anchorage, (Object)role);
    }

    @Override
    public void addAnchored(IVisualPart<VR, ? extends VR> anchored) {
        HashMultiset oldAnchoreds = this.anchoreds == null ? HashMultiset.create() : HashMultiset.create(this.anchoreds);
        IViewer<VR> oldViewer = this.getViewer();
        if (this.anchoreds == null) {
            this.anchoreds = HashMultiset.create();
        }
        this.anchoreds.add(anchored);
        IViewer<VR> newViewer = this.getViewer();
        if (oldViewer == null && newViewer != null) {
            this.register(newViewer);
        }
        this.pcs.firePropertyChange("anchoreds", oldAnchoreds, this.getAnchoreds());
    }

    @Override
    public void addChild(IVisualPart<VR, ? extends VR> child) {
        this.addChild(child, this.getChildren().size());
    }

    @Override
    public void addChild(IVisualPart<VR, ? extends VR> child, int index) {
        List<IVisualPart<VR, VR>> oldChildren = this.getChildren();
        this.addChildWithoutNotify(child, index);
        child.setParent(this);
        this.refreshVisual();
        this.addChildVisual(child, index);
        child.refreshVisual();
        if (this.isActive()) {
            child.activate();
        }
        this.pcs.firePropertyChange("children", oldChildren, this.getChildren());
    }

    @Override
    public void addChildren(List<? extends IVisualPart<VR, ? extends VR>> children) {
        for (IVisualPart<VR, VR> iVisualPart : children) {
            this.addChild(iVisualPart);
        }
    }

    @Override
    public void addChildren(List<? extends IVisualPart<VR, ? extends VR>> children, int index) {
        int i = children.size() - 1;
        while (i >= 0) {
            this.addChild(children.get(i), index);
            --i;
        }
    }

    protected void addChildVisual(IVisualPart<VR, ? extends VR> child, int index) {
        throw new UnsupportedOperationException("Need to properly implement addChildVisual(IVisualPart, int) for " + this.getClass());
    }

    private void addChildWithoutNotify(IVisualPart<VR, ? extends VR> child, int index) {
        if (this.children == null) {
            this.children = new ArrayList<IVisualPart<VR, ? extends VR>>(2);
        }
        this.children.add(index, child);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    protected void attachToAnchorageVisual(IVisualPart<VR, ? extends VR> anchorage, String role) {
        throw new UnsupportedOperationException("Need to implement attachToAnchorageVisual(IVisualPart, String) for " + this.getClass());
    }

    protected abstract V createVisual();

    public final void deactivate() {
        if (this.acs.isActive()) {
            this.doDeactivate();
            this.acs.deactivate();
        }
    }

    protected void detachFromAnchorageVisual(IVisualPart<VR, ? extends VR> anchorage, String role) {
        throw new UnsupportedOperationException("Need to implement detachFromAnchorageVisual(IVisualPart, String) for " + this.getClass());
    }

    public void dispose() {
        AdaptableScopes.leave((IAdaptable)this);
        this.ads.dispose();
    }

    protected void doActivate() {
        for (IVisualPart<VR, VR> child : this.getChildren()) {
            child.activate();
        }
    }

    protected void doDeactivate() {
        for (IVisualPart<VR, VR> child : this.getChildren()) {
            child.deactivate();
        }
    }

    protected abstract void doRefreshVisual(V var1);

    public <T> T getAdapter(AdapterKey<? super T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<? super T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<? super T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    @Override
    public SetMultimap<IVisualPart<VR, ? extends VR>, String> getAnchorages() {
        if (this.anchorages == null) {
            return Multimaps.unmodifiableSetMultimap((SetMultimap)HashMultimap.create());
        }
        return Multimaps.unmodifiableSetMultimap(this.anchorages);
    }

    @Override
    public Multiset<IVisualPart<VR, ? extends VR>> getAnchoreds() {
        if (this.anchoreds == null) {
            return Multisets.unmodifiableMultiset((Multiset)HashMultiset.create());
        }
        return Multisets.unmodifiableMultiset(this.anchoreds);
    }

    @Override
    public Map<AdapterKey<? extends IBehavior<VR>>, IBehavior<VR>> getBehaviors() {
        return this.ads.getAdapters(IBehavior.class);
    }

    @Override
    public List<IVisualPart<VR, ? extends VR>> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public IVisualPart<VR, ? extends VR> getParent() {
        return this.parent;
    }

    @Override
    public Map<AdapterKey<? extends IPolicy<VR>>, IPolicy<VR>> getPolicies() {
        return this.ads.getAdapters(IPolicy.class);
    }

    @Override
    public IRootPart<VR, ? extends VR> getRoot() {
        IRootPart<VR, VR> root;
        if (this.getParent() != null && (root = this.getParent().getRoot()) != null) {
            return root;
        }
        for (IVisualPart anchored : this.getAnchoreds().elementSet()) {
            IRootPart root2 = anchored.getRoot();
            if (root2 == null) continue;
            return root2;
        }
        return null;
    }

    protected IViewer<VR> getViewer() {
        IRootPart<VR, VR> root = this.getRoot();
        if (root == null) {
            return null;
        }
        return root.getViewer();
    }

    @Override
    public V getVisual() {
        if (this.visual == null) {
            this.visual = this.createVisual();
            IViewer<VR> viewer = this.getViewer();
            if (viewer != null) {
                this.registerAtVisualPartMap(viewer, this.visual);
            }
        }
        return this.visual;
    }

    public boolean isActive() {
        return this.acs.isActive();
    }

    @Override
    public boolean isRefreshVisual() {
        return this.refreshVisual;
    }

    @Override
    public final void refreshVisual() {
        if (this.visual != null && this.isRefreshVisual()) {
            this.doRefreshVisual(this.visual);
        }
    }

    protected void register(IViewer<VR> viewer) {
        if (this.visual != null) {
            this.registerAtVisualPartMap(viewer, this.visual);
        }
    }

    protected void registerAtVisualPartMap(IViewer<VR> viewer, V visual) {
        viewer.getVisualPartMap().put(visual, this);
    }

    @Override
    public void removeAnchorage(IVisualPart<VR, ? extends VR> anchorage) {
        this.removeAnchorage(anchorage, DEFAULT_ANCHORAGE_ROLE);
    }

    @Override
    public void removeAnchorage(IVisualPart<VR, ? extends VR> anchorage, String role) {
        HashMultimap oldAnchorages;
        if (anchorage == null) {
            throw new IllegalArgumentException("Anchorage may not be null.");
        }
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null.");
        }
        HashMultimap hashMultimap = oldAnchorages = this.anchorages == null ? HashMultimap.create() : HashMultimap.create(this.anchorages);
        if (!oldAnchorages.containsEntry(anchorage, (Object)role)) {
            throw new IllegalArgumentException("Not attached to anchorage " + anchorage + " in role '" + role + "'.");
        }
        this.removeAnchorageWithoutNotify(anchorage, role);
        anchorage.removeAnchored(this);
        this.detachFromAnchorageVisual(anchorage, role);
        this.pcs.firePropertyChange("anchorages", oldAnchorages, this.getAnchorages());
    }

    private void removeAnchorageWithoutNotify(IVisualPart<VR, ? extends VR> anchorage, String role) {
        if (this.anchorages == null) {
            throw new IllegalStateException("Cannot remove anchorage: not contained.");
        }
        if (!this.anchorages.remove(anchorage, (Object)role)) {
            throw new IllegalStateException("Cannot remove anchorage: not contained.");
        }
        if (this.anchorages.isEmpty()) {
            this.anchorages = null;
        }
    }

    @Override
    public void removeAnchored(IVisualPart<VR, ? extends VR> anchored) {
        HashMultiset oldAnchoreds = this.anchoreds == null ? HashMultiset.create() : HashMultiset.create(this.anchoreds);
        IViewer<VR> oldViewer = this.getViewer();
        this.anchoreds.remove(anchored);
        IViewer<VR> newViewer = this.getViewer();
        this.anchoreds.add(anchored);
        if (oldViewer != null && newViewer == null) {
            this.unregister(oldViewer);
        }
        this.anchoreds.remove(anchored);
        if (this.anchoreds.size() == 0) {
            this.anchoreds = null;
        }
        this.pcs.firePropertyChange("anchoreds", oldAnchoreds, this.getAnchoreds());
    }

    @Override
    public void removeChild(IVisualPart<VR, ? extends VR> child) {
        int index = this.getChildren().indexOf(child);
        if (index < 0) {
            return;
        }
        if (this.isActive()) {
            child.deactivate();
        }
        child.setParent(null);
        this.removeChildVisual(child, index);
        List<IVisualPart<VR, VR>> oldChildren = this.getChildren();
        this.removeChildWithoutNotify(child);
        this.pcs.firePropertyChange("children", oldChildren, this.getChildren());
    }

    @Override
    public void removeChildren(List<? extends IVisualPart<VR, ? extends VR>> children) {
        for (IVisualPart<VR, VR> iVisualPart : children) {
            this.removeChild(iVisualPart);
        }
    }

    protected void removeChildVisual(IVisualPart<VR, ? extends VR> child, int index) {
        throw new UnsupportedOperationException("Need to implement removeChildVisual(IVisualPart, int) for " + this.getClass());
    }

    private void removeChildWithoutNotify(IVisualPart<VR, ? extends VR> child) {
        this.children.remove(child);
        if (this.children.size() == 0) {
            this.children = null;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void reorderChild(IVisualPart<VR, ? extends VR> child, int index) {
        this.removeChildVisual(child, this.children.indexOf(child));
        this.removeChildWithoutNotify(child);
        this.addChildWithoutNotify(child, index);
        this.addChildVisual(child, index);
    }

    public <T> void setAdapter(AdapterKey<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    public <T> void setAdapter(Class<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    public <T> void setAdapter(TypeToken<? super T> key, T adapter) {
        this.ads.setAdapter(key, adapter);
    }

    @Inject(optional=true)
    public void setAdapters(@AdapterMap Map<AdapterKey<?>, Object> adaptersWithKeys) {
        this.ads.setAdapters(adaptersWithKeys, false);
    }

    @Override
    public void setParent(IVisualPart<VR, ? extends VR> newParent) {
        if (this.parent == newParent) {
            return;
        }
        IVisualPart<VR, VR> oldParent = this.parent;
        IViewer<VR> oldViewer = this.getViewer();
        this.parent = newParent;
        IViewer<VR> newViewer = this.getViewer();
        this.parent = oldParent;
        if (oldViewer != null && newViewer != oldViewer) {
            this.unregister(oldViewer);
        }
        this.parent = newParent;
        if (newViewer != null && newViewer != oldViewer) {
            this.register(newViewer);
        }
        this.pcs.firePropertyChange("parent", oldParent, newParent);
    }

    @Override
    public void setRefreshVisual(boolean isRefreshVisual) {
        this.refreshVisual = isRefreshVisual;
    }

    protected void unregister(IViewer<VR> viewer) {
        if (this.visual != null) {
            this.unregisterFromVisualPartMap(viewer, this.visual);
        }
    }

    protected void unregisterFromVisualPartMap(IViewer<VR> viewer, V visual) {
        Map<VR, IVisualPart<VR, VR>> registry = viewer.getVisualPartMap();
        if (registry.get(visual) != this) {
            throw new IllegalArgumentException("Not registered under visual");
        }
        registry.remove(visual);
    }

    public <T> T unsetAdapter(AdapterKey<? super T> key) {
        return (T)this.ads.unsetAdapter(key);
    }
}

