/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.nodes.ScrollPaneEx;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.models.ViewportModel;
import org.eclipse.gef4.zest.fx.models.ViewportStackModel;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class OpenNestedGraphOnZoomBehavior
extends AbstractBehavior<Node> {
    protected double zoomLevel;
    private PropertyChangeListener viewportPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("viewportContentsTransform".equals(evt.getPropertyName())) {
                Transform localToSceneTransform = ((Group)OpenNestedGraphOnZoomBehavior.this.getHost().getVisual()).getLocalToSceneTransform();
                AffineTransform transform = JavaFX2Geometry.toAffineTransform((Transform)localToSceneTransform);
                double lastZoomLevel = OpenNestedGraphOnZoomBehavior.this.zoomLevel;
                OpenNestedGraphOnZoomBehavior.this.zoomLevel = transform.getScaleX();
                OpenNestedGraphOnZoomBehavior.this.onZoomLevelChange(lastZoomLevel, OpenNestedGraphOnZoomBehavior.this.zoomLevel);
            }
        }
    };

    public void activate() {
        super.activate();
        Graph nestedGraph = this.getHost().getContent().getNestedGraph();
        if (nestedGraph != null) {
            this.zoomLevel = JavaFX2Geometry.toAffineTransform((Transform)((Group)this.getHost().getVisual()).getLocalToSceneTransform()).getScaleX();
            ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
            viewportModel.addPropertyChangeListener(this.viewportPropertyChangeListener);
        }
    }

    public void deactivate() {
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        viewportModel.removePropertyChangeListener(this.viewportPropertyChangeListener);
        super.deactivate();
    }

    public NodeContentPart getHost() {
        return (NodeContentPart)super.getHost();
    }

    protected void onZoomLevelChange(double oldScale, double newScale) {
        if (oldScale < newScale && newScale > 3.0) {
            Rectangle viewportBounds;
            Group hostVisual = (Group)this.getHost().getVisual();
            Bounds boundsInScene = hostVisual.localToScene(hostVisual.getLayoutBounds());
            ScrollPaneEx scrollPane = ((FXViewer)this.getHost().getRoot().getViewer()).getScrollPane();
            Rectangle boundsInViewport = JavaFX2Geometry.toRectangle((Bounds)scrollPane.sceneToLocal(boundsInScene));
            Rectangle intersected = boundsInViewport.getIntersected(viewportBounds = new Rectangle(0.0, 0.0, scrollPane.getWidth(), scrollPane.getHeight()));
            if (intersected.getArea() > viewportBounds.getArea() / 2.0) {
                ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
                ViewportStackModel viewportStackModel = (ViewportStackModel)this.getHost().getRoot().getViewer().getAdapter(ViewportStackModel.class);
                viewportStackModel.push(viewportModel);
                viewportModel.setContentsTransform(new AffineTransform());
                ContentModel contentModel = (ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class);
                viewportStackModel.addSkipNextLayout((Graph)contentModel.getContents().get(0));
                contentModel.setContents(Collections.singletonList(this.getHost().getContent().getNestedGraph()));
            }
        }
    }
}

