/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.models.ViewportModel;
import org.eclipse.gef4.mvc.operations.SynchronizeContentChildrenOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class SynchronizeChildrenOnZoomBehavior
extends AbstractBehavior<Node> {
    private PropertyChangeListener viewportPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("viewportContentsTransform".equals(evt.getPropertyName())) {
                double newScale;
                AffineTransform oldTransform = (AffineTransform)evt.getOldValue();
                AffineTransform newTransform = (AffineTransform)evt.getNewValue();
                double oldScale = oldTransform.getScaleX();
                if (oldScale != (newScale = newTransform.getScaleX())) {
                    SynchronizeChildrenOnZoomBehavior.this.onZoomLevelChange(oldScale, newScale);
                }
            }
        }
    };

    public void activate() {
        super.activate();
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        viewportModel.addPropertyChangeListener(this.viewportPropertyChangeListener);
    }

    public void deactivate() {
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        viewportModel.removePropertyChangeListener(this.viewportPropertyChangeListener);
        super.deactivate();
    }

    public NodeContentPart getHost() {
        return (NodeContentPart)super.getHost();
    }

    protected void onZoomLevelChange(double oldScale, double newScale) {
        if (!this.isActive()) {
            return;
        }
        try {
            new SynchronizeContentChildrenOperation("SyncOnZoom", (IContentPart)this.getHost()).execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

