/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.layout;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.AbstractLayoutContext;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.ISubgraphLayout;
import org.eclipse.gef4.zest.fx.layout.GraphEdgeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphNodeLayout;

public class GraphLayoutContext
extends AbstractLayoutContext {
    private Graph g;
    private final Map<Node, GraphNodeLayout> nodeMap = new IdentityHashMap<Node, GraphNodeLayout>();
    private final Map<Edge, GraphEdgeLayout> edgeMap = new IdentityHashMap<Edge, GraphEdgeLayout>();

    public GraphLayoutContext(Graph graph) {
        this.setGraph(graph);
    }

    public ISubgraphLayout createSubgraph(INodeLayout[] nodes) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IConnectionLayout[] getConnections() {
        IConnectionLayout[] all;
        ArrayList<IConnectionLayout> connections = new ArrayList<IConnectionLayout>();
        IConnectionLayout[] iConnectionLayoutArray = all = super.getConnections();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionLayout c = iConnectionLayoutArray[n2];
            if (!(this.isLayoutIrrelevant(c) || this.isLayoutIrrelevant(c.getSource()) || this.isLayoutIrrelevant(c.getTarget()))) {
                connections.add(c);
            }
            ++n2;
        }
        return connections.toArray(new IConnectionLayout[0]);
    }

    public GraphEdgeLayout getEdgeLayout(Edge edge) {
        return this.edgeMap.get(edge);
    }

    public IEntityLayout[] getEntities() {
        return this.getNodes();
    }

    public Graph getGraph() {
        return this.g;
    }

    public GraphNodeLayout getNodeLayout(Node node) {
        return this.nodeMap.get(node);
    }

    public INodeLayout[] getNodes() {
        INodeLayout[] allNodes;
        ArrayList<INodeLayout> nodes = new ArrayList<INodeLayout>();
        INodeLayout[] iNodeLayoutArray = allNodes = super.getNodes();
        int n = allNodes.length;
        int n2 = 0;
        while (n2 < n) {
            INodeLayout n3 = iNodeLayoutArray[n2];
            if (!this.isLayoutIrrelevant(n3)) {
                nodes.add(n3);
            }
            ++n2;
        }
        return nodes.toArray(new INodeLayout[0]);
    }

    public void setGraph(Graph graph) {
        this.g = graph;
        this.transferNodes();
        this.transferEdges();
    }

    private void transferEdges() {
        this.clearEdges();
        this.edgeMap.clear();
        for (Edge edge : this.g.getEdges()) {
            GraphEdgeLayout graphConnection = new GraphEdgeLayout(this, edge);
            this.addEdge(graphConnection);
            this.edgeMap.put(edge, graphConnection);
        }
    }

    private void transferNodes() {
        this.clearNodes();
        this.nodeMap.clear();
        for (Node node : this.g.getNodes()) {
            GraphNodeLayout graphNode = new GraphNodeLayout(this, node);
            this.addNode(graphNode);
            this.nodeMap.put(node, graphNode);
        }
    }
}

