/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gef4.common.properties.IPropertyStore;
import org.eclipse.gef4.common.properties.PropertyStoreSupport;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.ISubgraphLayout;

public class GraphSubgraphLayout
implements ISubgraphLayout {
    private List<INodeLayout> nodes = new ArrayList<INodeLayout>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyStoreSupport pss = new PropertyStoreSupport((IPropertyStore)this, this.pcs);

    public void addNodes(INodeLayout[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        this.nodes.addAll(Arrays.asList(nodes));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public Object[] getItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (INodeLayout node : this.nodes) {
            items.addAll(Arrays.asList(node.getItems()));
        }
        return items.toArray();
    }

    public INodeLayout[] getNodes() {
        return this.nodes.toArray(new INodeLayout[0]);
    }

    public IEntityLayout[] getPredecessingEntities() {
        ArrayList<IEntityLayout> predecessors = new ArrayList<IEntityLayout>();
        for (INodeLayout node : this.nodes) {
            predecessors.addAll(Arrays.asList(node.getPredecessingEntities()));
        }
        return predecessors.toArray(new IEntityLayout[0]);
    }

    public Object getProperty(String name) {
        return this.pss.getProperty(name);
    }

    public IEntityLayout[] getSuccessingEntities() {
        ArrayList<IEntityLayout> successors = new ArrayList<IEntityLayout>();
        for (INodeLayout node : this.nodes) {
            successors.addAll(Arrays.asList(node.getSuccessingEntities()));
        }
        return successors.toArray(new IEntityLayout[0]);
    }

    public void removeNodes(INodeLayout[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        this.nodes.removeAll(Arrays.asList(nodes));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setProperty(String name, Object value) {
        this.pss.setProperty(name, value);
    }
}

