/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.graph.Node;

public class HidingModel
implements IPropertyChangeNotifier {
    public static final String HIDDEN_PROPERTY = "hidden";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Set<Node> hidden = Collections.newSetFromMap(new IdentityHashMap());

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public Set<Node> getHiddenNeighbors(Node node) {
        Set neighbors = node.getLocalNeighbors();
        Set<Node> hiddenNeighbors = Collections.newSetFromMap(new IdentityHashMap());
        for (Node n : neighbors) {
            if (!this.isHidden(n)) continue;
            hiddenNeighbors.add(n);
        }
        return hiddenNeighbors;
    }

    public Set<Node> getHiddenNodes() {
        Set<Node> copy = Collections.newSetFromMap(new IdentityHashMap());
        copy.addAll(this.hidden);
        return copy;
    }

    public void hide(Node node) {
        Set<Node> oldHidden = this.getHiddenNodes();
        this.hidden.add(node);
        this.pcs.firePropertyChange(HIDDEN_PROPERTY, oldHidden, this.getHiddenNodes());
    }

    public boolean isHidden(Node node) {
        return this.hidden.contains(node);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void show(Node node) {
        Set<Node> oldHidden = this.getHiddenNodes();
        this.hidden.remove(node);
        this.pcs.firePropertyChange(HIDDEN_PROPERTY, oldHidden, this.getHiddenNodes());
    }
}

