/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.operations;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class HideOperation
extends AbstractOperation {
    private NodeContentPart node;
    private boolean isHidden;

    public static HideOperation hide(NodeContentPart toHide) {
        return new HideOperation(toHide, false);
    }

    public static HideOperation show(NodeContentPart toShow) {
        return new HideOperation(toShow, true);
    }

    public HideOperation(NodeContentPart node, boolean isHidden) {
        super("hide/show");
        this.node = node;
        this.isHidden = isHidden;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.isHidden) {
            this.show();
        } else {
            this.hide();
        }
        return Status.OK_STATUS;
    }

    protected Node[] getNeighbors(Node node) {
        HashSet neighbors = new HashSet();
        neighbors.addAll(node.getLocalPredecessorNodes());
        neighbors.addAll(node.getLocalSuccessorNodes());
        return neighbors.toArray(new Node[0]);
    }

    protected void hide() {
        ((HidingModel)this.node.getRoot().getViewer().getAdapter(HidingModel.class)).hide(this.node.getContent());
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    protected void show() {
        ((HidingModel)this.node.getRoot().getViewer().getAdapter(HidingModel.class)).show(this.node.getContent());
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.isHidden) {
            this.hide();
        } else {
            this.show();
        }
        return Status.OK_STATUS;
    }
}

