/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.shape.Polyline;
import javafx.scene.text.Text;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.fx.nodes.IFXConnectionRouter;
import org.eclipse.gef4.fx.nodes.IFXDecoration;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.models.LayoutModel;
import org.eclipse.gef4.zest.fx.parts.EdgeLabelPart;

public class EdgeContentPart
extends AbstractFXContentPart<FXConnection> {
    @Inject
    private Injector injector;
    private PropertyChangeListener edgeAttributesPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("attributes".equals(evt.getPropertyName())) {
                EdgeContentPart.this.refreshVisual();
            }
        }
    };
    public static final String CSS_CLASS = "edge";
    public static final String CSS_CLASS_CURVE = "curve";
    public static final String CSS_CLASS_LABEL = "label";
    private static final double GAP_LENGTH = 7.0;
    private static final double DASH_LENGTH = 7.0;
    private static final Double DOT_LENGTH = 1.0;
    private EdgeLabelPart edgeLabelPart;

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        if (!((FXConnection)this.getVisual()).getChildren().contains(child.getVisual())) {
            ((FXConnection)this.getVisual()).getChildren().add((Object)((Node)child.getVisual()));
        }
    }

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        IFXAnchor anchor;
        Provider anchorProvider = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IFXAnchor>>(){}));
        IFXAnchor iFXAnchor = anchor = anchorProvider == null ? null : (IFXAnchor)anchorProvider.get();
        if (role.equals("START")) {
            ((FXConnection)this.getVisual()).setStartAnchor(anchor);
        } else if (role.equals("END")) {
            ((FXConnection)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalStateException("Cannot attach to anchor with role <" + role + ">.");
        }
    }

    protected FXConnection createVisual() {
        FXConnection visual = new FXConnection();
        visual.getStyleClass().add((Object)CSS_CLASS);
        visual.getCurveNode().getStyleClass().add((Object)CSS_CLASS_CURVE);
        return visual;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        FXConnection connection = (FXConnection)this.getVisual();
        if (role.equals("START")) {
            Point startPoint = connection.getStartPoint();
            connection.setStartPoint(startPoint == null ? new Point() : startPoint);
        } else {
            Point endPoint = connection.getEndPoint();
            connection.setEndPoint(endPoint == null ? new Point() : endPoint);
        }
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().addPropertyChangeListener(this.edgeAttributesPropertyChangeListener);
        if (this.edgeLabelPart == null) {
            this.edgeLabelPart = (EdgeLabelPart)((Object)this.injector.getInstance(EdgeLabelPart.class));
            ((Text)this.edgeLabelPart.getVisual()).getStyleClass().add((Object)CSS_CLASS_LABEL);
            this.getParent().addChild((IVisualPart)this.edgeLabelPart);
            this.edgeLabelPart.addAnchorage((IVisualPart)this);
        }
    }

    protected void doDeactivate() {
        this.getContent().removePropertyChangeListener(this.edgeAttributesPropertyChangeListener);
        super.doDeactivate();
    }

    public void doRefreshVisual(FXConnection visual) {
        Object style;
        IFXConnectionRouter router;
        IFXDecoration targetDecoration;
        Object label;
        LayoutModel glc = this.getLayoutModel();
        if (glc == null || this.edgeLabelPart == null) {
            return;
        }
        Edge edge = this.getContent();
        Map attrs = edge.getAttrs();
        FXGeometryNode curveNode = visual.getCurveNode();
        visual.getStyleClass().clear();
        visual.getStyleClass().add((Object)CSS_CLASS);
        if (attrs.containsKey("css-class")) {
            String cssClass = ZestProperties.getCssClass(edge);
            visual.getStyleClass().add((Object)cssClass);
        }
        if (attrs.containsKey("css-id")) {
            String cssId = ZestProperties.getCssId(edge);
            visual.setId(cssId);
        }
        if (attrs.containsKey("edge-curve-css-style")) {
            String connCssStyle = ZestProperties.getEdgeCurveCssStyle(edge);
            curveNode.setStyle(connCssStyle);
        }
        if (attrs.containsKey("edge-label-css-style")) {
            String textCssStyle = ZestProperties.getEdgeLabelCssStyle(edge);
            ((Text)this.edgeLabelPart.getVisual()).setStyle(textCssStyle);
        }
        if ((label = attrs.get(CSS_CLASS_LABEL)) instanceof String) {
            ((Text)this.edgeLabelPart.getVisual()).setText((String)label);
        }
        if ("directed".equals(ZestProperties.getType(glc.getGraph(), true))) {
            visual.setEndDecoration((IFXDecoration)new ArrowHead());
        } else {
            visual.setEndDecoration(null);
        }
        IFXDecoration sourceDecoration = ZestProperties.getSourceDecoration(edge);
        if (sourceDecoration != null) {
            visual.setStartDecoration(sourceDecoration);
        }
        if ((targetDecoration = ZestProperties.getTargetDecoration(edge)) != null) {
            visual.setEndDecoration(targetDecoration);
        }
        if ((router = ZestProperties.getRouter(edge)) != null) {
            visual.setRouter(router);
        }
        if ((style = attrs.get("style")) == "dashed") {
            curveNode.getStrokeDashArray().setAll((Object[])new Double[]{7.0, 7.0});
        } else if (style == "dashdot") {
            curveNode.getStrokeDashArray().setAll((Object[])new Double[]{7.0, 7.0, DOT_LENGTH, 7.0});
        } else if (style == "dashdotdot") {
            curveNode.getStrokeDashArray().setAll((Object[])new Double[]{7.0, 7.0, DOT_LENGTH, 7.0, DOT_LENGTH, 7.0});
        } else if (style == "dotted") {
            curveNode.getStrokeDashArray().setAll((Object[])new Double[]{DOT_LENGTH, 7.0});
        } else {
            curveNode.getStrokeDashArray().clear();
        }
    }

    public Edge getContent() {
        return (Edge)super.getContent();
    }

    public SetMultimap<Object, String> getContentAnchorages() {
        HashMultimap anchorages = HashMultimap.create();
        anchorages.put((Object)this.getContent().getSource(), (Object)"START");
        anchorages.put((Object)this.getContent().getTarget(), (Object)"END");
        return anchorages;
    }

    protected LayoutModel getLayoutModel() {
        return (LayoutModel)((Object)((IContentPart)this.getViewer().getContentPartMap().get(this.getContent().getGraph())).getAdapter(LayoutModel.class));
    }

    protected void register(IViewer<Node> viewer) {
        super.register(viewer);
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((FXConnection)this.getVisual()).getChildren().remove(child.getVisual());
    }

    public void setContent(Object content) {
        super.setContent(content);
        if (content == null) {
            return;
        }
        if (!(content instanceof Edge)) {
            throw new IllegalArgumentException("Content of wrong type!");
        }
        final FXConnection visual = (FXConnection)this.getVisual();
        this.setAdapter(AdapterKey.get(Provider.class, (String)"SELECTION_FEEDBACK_GEOMETRY_PROVIDER"), new Provider<IGeometry>(){

            public IGeometry get() {
                return FXUtils.localToParent((Node)visual, (IGeometry)FXUtils.localToParent((Node)visual.getCurveNode(), (IGeometry)visual.getCurveNode().getGeometry()));
            }
        });
        this.setAdapter(AdapterKey.get(Provider.class, (String)"HOVER_FEEDBACK_GEOMETRY_PROVIDER"), new Provider<IGeometry>(){

            public IGeometry get() {
                return FXUtils.localToParent((Node)visual, (IGeometry)FXUtils.localToParent((Node)visual.getCurveNode(), (IGeometry)visual.getCurveNode().getGeometry()));
            }
        });
    }

    protected void unregister(IViewer<Node> viewer) {
        if (this.edgeLabelPart != null) {
            this.removeAnchored((IVisualPart)this.edgeLabelPart);
            this.getParent().removeChild((IVisualPart)this.edgeLabelPart);
            this.edgeLabelPart = null;
        }
        super.unregister(viewer);
    }

    public static class ArrowHead
    extends Polyline
    implements IFXDecoration {
        public ArrowHead() {
            super(new double[]{15.0, 0.0, 10.0, 0.0, 10.0, 3.0, 0.0, 0.0, 10.0, -3.0, 10.0, 0.0});
        }

        public Point getLocalEndPoint() {
            return new Point(15.0, 0.0);
        }

        public Point getLocalStartPoint() {
            return new Point(0.0, 0.0);
        }

        public Node getVisual() {
            return this;
        }
    }
}

