/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;

public class NodeContentPart
extends AbstractFXContentPart<Group> {
    protected static final double DEFAULT_PADDING = 5.0;
    protected static final double ZOOMLEVEL_SHOW_NESTED_GRAPH = 2.0;
    protected static final double DEFAULT_CHILDREN_PANE_WIDTH = 300.0;
    protected static final double DEFAULT_CHILDREN_PANE_HEIGHT = 300.0;
    protected static final double CHILDREN_PANE_WIDTH_THRESHOLD = 100.0;
    protected static final double CHILDREN_PANE_HEIGHT_THRESHOLD = 100.0;
    public static final String CSS_CLASS = "node";
    public static final String CSS_CLASS_SHAPE = "shape";
    public static final String CSS_CLASS_LABEL = "label";
    public static final String CSS_CLASS_ICON = "icon";
    private static final String NODE_LABEL_EMPTY = "-";
    private Text labelText;
    private ImageView iconImageView;
    private Node nestedGraphIcon;
    private StackPane nestedContentStackPane;
    private Pane nestedChildrenPane;
    private int originalIndex = -1;
    private Bounds originalBounds = null;
    private Tooltip tooltipNode;
    private HBox hbox;
    private VBox vbox;
    private Rectangle rect;
    private EventHandler<? super MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            EventType type = event.getEventType();
            if (type.equals(MouseEvent.MOUSE_ENTERED) || type.equals(MouseEvent.MOUSE_EXITED)) {
                NodeContentPart.this.refreshVisual();
            } else if ((type.equals(MouseEvent.MOUSE_MOVED) || type.equals(MouseEvent.MOUSE_DRAGGED)) && NodeContentPart.this.originalBounds != null && !NodeContentPart.this.originalBounds.contains(event.getSceneX(), event.getSceneY())) {
                ((Group)NodeContentPart.this.getVisual()).setMouseTransparent(true);
            }
        }
    };
    private PropertyChangeListener nodeAttributesPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("attributes".equals(evt.getPropertyName())) {
                NodeContentPart.this.refreshVisual();
            }
        }
    };

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        this.getNestedChildrenPane().getChildren().add(index, (Object)((Node)child.getVisual()));
    }

    protected Pane createNestedContentPane() {
        Pane pane = new Pane();
        pane.setStyle("-fx-background-color: white;");
        pane.setScaleX(0.25);
        pane.setScaleY(0.25);
        pane.setPrefSize(0.0, 0.0);
        return pane;
    }

    protected StackPane createNestedContentStackPane(Pane nestedContentPane) {
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)new Group(new Node[]{nestedContentPane}));
        return stackPane;
    }

    protected void createNodeVisual(Group group, final Rectangle rect, ImageView iconImageView, Text labelText, StackPane nestedContentStackPane) {
        this.hbox = new HBox();
        this.hbox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.hbox.getChildren().addAll((Object[])new Node[]{iconImageView, labelText});
        this.vbox = new VBox();
        this.vbox.setMouseTransparent(true);
        this.vbox.getChildren().addAll((Object[])new Node[]{this.hbox, nestedContentStackPane});
        this.vbox.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                NodeContentPart.this.vbox.setTranslateX(NodeContentPart.this.getPadding());
                NodeContentPart.this.vbox.setTranslateY(NodeContentPart.this.getPadding());
                rect.setWidth(NodeContentPart.this.vbox.getWidth() + 2.0 * NodeContentPart.this.getPadding());
                rect.setHeight(NodeContentPart.this.vbox.getHeight() + 2.0 * NodeContentPart.this.getPadding());
            }
        });
        group.getChildren().addAll((Object[])new Node[]{rect, this.vbox});
    }

    protected Group createVisual() {
        Group group = new Group(){

            public boolean isResizable() {
                return NodeContentPart.this.isNesting();
            }

            public void resize(double w, double h) {
                if (!this.isResizable()) {
                    return;
                }
                Bounds layoutBounds = this.getLayoutBounds();
                NodeContentPart.this.resizeNestedGraphArea(w - layoutBounds.getWidth(), h - layoutBounds.getHeight());
            }
        };
        this.rect = new Rectangle();
        this.rect.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.REFLECT, Arrays.asList(new Stop(0.0, new Color(1.0, 1.0, 1.0, 1.0)))));
        this.rect.setStroke((Paint)new Color(0.0, 0.0, 0.0, 1.0));
        this.rect.getStyleClass().add((Object)CSS_CLASS_SHAPE);
        this.nestedChildrenPane = this.createNestedContentPane();
        this.nestedContentStackPane = this.createNestedContentStackPane(this.nestedChildrenPane);
        this.iconImageView = new ImageView();
        this.iconImageView.setImage(null);
        this.iconImageView.getStyleClass().add((Object)CSS_CLASS_ICON);
        this.labelText = new Text();
        this.labelText.setTextOrigin(VPos.TOP);
        this.labelText.setText(NODE_LABEL_EMPTY);
        this.labelText.getStyleClass().add((Object)CSS_CLASS_LABEL);
        this.createNodeVisual(group, this.rect, this.iconImageView, this.labelText, this.nestedContentStackPane);
        return group;
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().addPropertyChangeListener(this.nodeAttributesPropertyChangeListener);
    }

    protected void doDeactivate() {
        this.getContent().removePropertyChangeListener(this.nodeAttributesPropertyChangeListener);
        super.doDeactivate();
    }

    public void doRefreshVisual(Group visual) {
        Object label;
        if (this.getContent() == null) {
            throw new IllegalStateException();
        }
        visual.getStyleClass().clear();
        visual.getStyleClass().add((Object)CSS_CLASS);
        org.eclipse.gef4.graph.Node node = this.getContent();
        Map attrs = node.getAttrs();
        if (attrs.containsKey("css-class")) {
            this.refreshCssClass(visual, ZestProperties.getCssClass(node));
        }
        String id = null;
        if (attrs.containsKey("css-id")) {
            id = ZestProperties.getCssId(node);
        }
        visual.setId(id);
        if (attrs.containsKey("node-rect-css-style")) {
            this.rect.setStyle(ZestProperties.getNodeRectCssStyle(node));
        }
        if (attrs.containsKey("node-label-css-style")) {
            this.labelText.setStyle(ZestProperties.getNodeLabelCssStyle(node));
        }
        if ((label = attrs.get(CSS_CLASS_LABEL)) == null) {
            label = id;
        }
        String str = label instanceof String ? (String)label : (label == null ? NODE_LABEL_EMPTY : label.toString());
        str = this.refreshFisheye(visual, attrs, str);
        this.refreshLabel(visual, str);
        this.refreshIcon(visual, attrs.get(CSS_CLASS_ICON));
        this.refreshNestedGraphArea(visual, this.isNesting());
        this.refreshTooltip(visual, attrs.get("tooltip"));
    }

    public org.eclipse.gef4.graph.Node getContent() {
        return (org.eclipse.gef4.graph.Node)super.getContent();
    }

    public List<? extends Object> getContentChildren() {
        Graph nestedGraph = this.getContent().getNestedGraph();
        if (nestedGraph == null) {
            return Collections.emptyList();
        }
        Transform tx = ((Group)this.getVisual()).getLocalToSceneTransform();
        double scale = JavaFX2Geometry.toAffineTransform((Transform)tx).getScaleX();
        if (scale > 2.0) {
            this.hideNestedGraphIcon();
            return Collections.singletonList(nestedGraph);
        }
        this.showNestedGraphIcon();
        return Collections.emptyList();
    }

    protected ImageView getIconImageView() {
        return this.iconImageView;
    }

    protected Text getLabelText() {
        return this.labelText;
    }

    public Pane getNestedChildrenPane() {
        return this.nestedChildrenPane;
    }

    protected StackPane getNestedContentStackPane() {
        return this.nestedContentStackPane;
    }

    protected Node getNestedGraphIcon() {
        return this.nestedGraphIcon;
    }

    protected Rectangle getNodeRect() {
        return this.rect;
    }

    protected double getPadding() {
        return 5.0;
    }

    protected void hideNestedGraphIcon() {
        if (this.getNestedGraphIcon() != null) {
            this.getNestedContentStackPane().getChildren().remove((Object)this.getNestedGraphIcon());
            this.setNestedGraphIcon(null);
        }
    }

    protected boolean isNesting() {
        return this.getContent().getNestedGraph() != null;
    }

    protected void refreshCssClass(Group visual, String cssClass) {
        visual.getStyleClass().add((Object)cssClass);
    }

    protected String refreshFisheye(Group visual, Map<String, Object> attrs, String str) {
        Object fisheye = attrs.get("fisheye");
        if (fisheye instanceof Boolean && ((Boolean)fisheye).booleanValue()) {
            visual.addEventHandler(MouseEvent.ANY, this.mouseHandler);
            if (!visual.isHover()) {
                str = str.substring(0, 1);
                this.restoreZOrder();
            } else {
                if (this.originalBounds == null) {
                    this.originalBounds = visual.localToScene(visual.getLayoutBounds());
                }
                List children = this.getParent().getChildren();
                this.originalIndex = children.indexOf((Object)this);
                this.getParent().reorderChild((IVisualPart)this, children.size() - 1);
                visual.toFront();
            }
        } else {
            this.restoreZOrder();
            visual.removeEventHandler(MouseEvent.ANY, this.mouseHandler);
        }
        return str;
    }

    protected void refreshIcon(Group visual, Object icon) {
        if (this.iconImageView.getImage() != icon && icon instanceof Image) {
            this.iconImageView.setImage((Image)icon);
        }
    }

    protected void refreshLabel(Group visual, String str) {
        if (!this.labelText.getText().equals(str)) {
            this.labelText.setText(str);
        }
    }

    protected void refreshNestedGraphArea(Group visual, boolean isNesting) {
        Pane nestedContentPane = this.getNestedChildrenPane();
        if (isNesting) {
            if (nestedContentPane.getPrefWidth() == 0.0 && nestedContentPane.getPrefHeight() == 0.0) {
                nestedContentPane.setPrefSize(300.0, 300.0);
                nestedContentPane.resize(300.0, 300.0);
            }
        } else if (nestedContentPane.getPrefWidth() != 0.0 || nestedContentPane.getPrefHeight() != 0.0) {
            nestedContentPane.setPrefSize(0.0, 0.0);
            nestedContentPane.resize(0.0, 0.0);
        }
    }

    protected void refreshTooltip(Group visual, Object tooltip) {
        if (tooltip instanceof String) {
            if (this.tooltipNode == null) {
                this.tooltipNode = new Tooltip((String)tooltip);
                Tooltip.install((Node)visual, (Tooltip)this.tooltipNode);
            } else {
                this.tooltipNode.setText((String)tooltip);
            }
        }
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        this.getNestedChildrenPane().getChildren().remove(index);
    }

    protected void resizeNestedGraphArea(double dw, double dh) {
        Pane nestedContentPane = this.getNestedChildrenPane();
        double newWidth = nestedContentPane.getPrefWidth() + dw * 1.0 / nestedContentPane.getScaleX();
        double newHeight = nestedContentPane.getPrefHeight() + dh * 1.0 / nestedContentPane.getScaleY();
        if (newWidth < 100.0) {
            newWidth = 100.0;
        }
        if (newHeight < 100.0) {
            newHeight = 100.0;
        }
        double oldWidth = nestedContentPane.getWidth();
        double oldHeight = nestedContentPane.getHeight();
        dw = newWidth - oldWidth;
        dh = newHeight - oldHeight;
        double dx = nestedContentPane.getScaleX() * dw / 2.0;
        double dy = nestedContentPane.getScaleY() * dh / 2.0;
        nestedContentPane.setPrefSize(newWidth, newHeight);
        nestedContentPane.resize(newWidth, newHeight);
        ((Group)this.getVisual()).setLayoutX(((Group)this.getVisual()).getLayoutX() + dx);
        ((Group)this.getVisual()).setLayoutY(((Group)this.getVisual()).getLayoutY() + dy);
    }

    private void restoreZOrder() {
        if (this.originalIndex >= 0) {
            this.getParent().reorderChild((IVisualPart)this, this.originalIndex);
        }
        ((Group)this.getVisual()).setMouseTransparent(false);
        this.originalBounds = null;
    }

    protected void setNestedGraphIcon(Node nestedGraphIcon) {
        this.nestedGraphIcon = nestedGraphIcon;
    }

    protected void showNestedGraphIcon() {
        if (this.getNestedGraphIcon() == null) {
            this.setNestedGraphIcon((Node)new NestedGraphIcon());
            this.getNestedContentStackPane().getChildren().add((Object)this.getNestedGraphIcon());
        }
    }

    public static class NestedGraphIcon
    extends Group {
        public NestedGraphIcon() {
            Circle n0 = this.node(-20.0, -20.0);
            Circle n1 = this.node(-10.0, 10.0);
            Circle n2 = this.node(5.0, -15.0);
            Circle n3 = this.node(15.0, -25.0);
            Circle n4 = this.node(20.0, 5.0);
            this.getChildren().addAll((Object[])new Node[]{this.edge(n0, n1), this.edge(n1, n2), this.edge(n2, n3), this.edge(n3, n4), this.edge(n1, n4), n0, n1, n2, n3, n4});
        }

        private Node edge(Circle n, Circle m) {
            Line line = new Line(n.getCenterX(), n.getCenterY(), m.getCenterX(), m.getCenterY());
            line.setStroke((Paint)Color.BLACK);
            return line;
        }

        private Circle node(double x, double y) {
            return new Circle(x, y, 5.0, (Paint)Color.BLACK);
        }
    }
}

