/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.SelectionBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.parts.EdgeContentPart;
import org.eclipse.gef4.zest.fx.parts.EdgeLabelPart;
import org.eclipse.gef4.zest.fx.parts.ZestFxEdgeLinkFeedbackPart;

public class ZestFxFeedbackPartFactory
extends FXDefaultFeedbackPartFactory {
    @Inject
    private Injector injector;

    protected IFeedbackPart<Node, ? extends Node> createEdgeLabelLinkFeedbackPart(final EdgeContentPart edgeContentPart, final EdgeLabelPart edgeLabelPart) {
        Provider<IGeometry> linkFeedbackGeometryProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                FXGeometryNode curveNode = ((FXConnection)edgeContentPart.getVisual()).getCurveNode();
                BezierCurve[] bezier = ((ICurve)curveNode.getGeometry()).toBezier();
                Point sourcePoint = bezier[bezier.length / 2].get(0.5);
                Point2D sourcePoint2DInScene = curveNode.localToScene(sourcePoint.x, sourcePoint.y);
                Point sourcePointInScene = new Point(sourcePoint2DInScene.getX(), sourcePoint2DInScene.getY());
                Node labelVisual = (Node)edgeLabelPart.getVisual();
                Bounds bounds = labelVisual.getLayoutBounds();
                Point2D targetPoint2DInScene = labelVisual.localToScene(bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() / 2.0);
                Point targetPointInScene = new Point(targetPoint2DInScene.getX(), targetPoint2DInScene.getY());
                return new Line(sourcePointInScene, targetPointInScene);
            }
        };
        ZestFxEdgeLinkFeedbackPart zestFxEdgeLinkFeedbackPart = new ZestFxEdgeLinkFeedbackPart(linkFeedbackGeometryProvider);
        this.injector.injectMembers((Object)zestFxEdgeLinkFeedbackPart);
        return zestFxEdgeLinkFeedbackPart;
    }

    protected List<IFeedbackPart<Node, ? extends Node>> createSelectionFeedbackParts(List<? extends IVisualPart<Node, ? extends Node>> targets, SelectionBehavior<Node> selectionBehavior, Map<Object, Object> contextMap) {
        List parts = super.createSelectionFeedbackParts(targets, selectionBehavior, contextMap);
        for (IVisualPart<Node, ? extends Node> iVisualPart : targets) {
            IFeedbackPart<Node, ? extends Node> edgeLabelLinkFeedbackPart;
            if (!(iVisualPart instanceof EdgeContentPart)) continue;
            EdgeLabelPart labelPart = null;
            for (IVisualPart anchored : iVisualPart.getAnchoreds()) {
                if (!(anchored instanceof EdgeLabelPart)) continue;
                labelPart = (EdgeLabelPart)anchored;
            }
            if (labelPart == null || (edgeLabelLinkFeedbackPart = this.createEdgeLabelLinkFeedbackPart((EdgeContentPart)iVisualPart, labelPart)) == null) continue;
            parts.add(edgeLabelLinkFeedbackPart);
        }
        return parts;
    }
}

