/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ProcessStatusInterval;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedThreadStatus;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.Messages;

public class AggregatedCalledFunction
extends AggregatedCallSite {
    private final AggregatedCalledFunctionStatistics fStatistics;
    private long fDuration = 0L;
    private long fSelfTime = 0L;
    private long fCpuTime = -1L;
    private int fProcessId;
    private Map<ProcessStatus, AggregatedThreadStatus> fProcessStatuses = new HashMap<ProcessStatus, AggregatedThreadStatus>();

    public AggregatedCalledFunction(ICallStackSymbol symbol) {
        super(symbol, 0L);
        this.fStatistics = new AggregatedCalledFunctionStatistics();
        this.fProcessId = -1;
    }

    public AggregatedCalledFunction(AggregatedCalledFunction toCopy) {
        super((AggregatedCallSite)toCopy);
        this.fStatistics = new AggregatedCalledFunctionStatistics();
        this.fStatistics.merge(toCopy.fStatistics);
        this.fProcessId = toCopy.fProcessId;
        this.fDuration = toCopy.fDuration;
        this.fSelfTime = toCopy.fSelfTime;
        this.fCpuTime = toCopy.fCpuTime;
        this.mergeProcessStatuses(toCopy);
    }

    public long getWeight() {
        return this.fDuration;
    }

    public AggregatedCalledFunction copyOf() {
        return new AggregatedCalledFunction(this);
    }

    protected void mergeData(@NonNull WeightedTree<ICallStackSymbol> other) {
        if (!(other instanceof AggregatedCalledFunction)) {
            return;
        }
        AggregatedCalledFunction otherFct = (AggregatedCalledFunction)other;
        this.addToDuration(otherFct.getDuration());
        this.addToSelfTime(otherFct.getSelfTime());
        this.addToCpuTime(otherFct.getCpuTime());
        this.getFunctionStatistics().merge(otherFct.getFunctionStatistics(), true);
        this.mergeProcessStatuses(otherFct);
    }

    private void mergeProcessStatuses(AggregatedCalledFunction other) {
        Map<ProcessStatus, AggregatedThreadStatus> processStatuses = other.fProcessStatuses;
        for (Map.Entry<ProcessStatus, AggregatedThreadStatus> entry : processStatuses.entrySet()) {
            AggregatedThreadStatus status = this.fProcessStatuses.get(entry.getKey());
            if (status == null) {
                status = new AggregatedThreadStatus(entry.getKey());
            }
            status.merge((WeightedTree)entry.getValue());
            this.fProcessStatuses.put(entry.getKey(), status);
        }
    }

    public Map<String, IStatistics<?>> getStatistics() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)String.valueOf(Messages.CallGraphStats_Duration), this.getFunctionStatistics().getDurationStatistics());
        builder.put((Object)String.valueOf(Messages.CallGraphStats_SelfTime), this.getFunctionStatistics().getSelfTimeStatistics());
        builder.put((Object)String.valueOf(Messages.CallGraphStats_CpuTime), this.getFunctionStatistics().getCpuTimesStatistics());
        return builder.build();
    }

    public synchronized void addChild(AbstractCalledFunction child, AggregatedCalledFunction aggregatedChild) {
        this.fSelfTime -= aggregatedChild.getDuration();
        aggregatedChild.addFunctionCall(child);
        super.addChild((WeightedTree)aggregatedChild);
    }

    public synchronized void addFunctionCall(AbstractCalledFunction function) {
        this.addToDuration(function.getLength());
        this.addToSelfTime(function.getSelfTime());
        this.addToCpuTime(function.getCpuTime());
        this.fProcessId = function.getProcessId();
        this.getFunctionStatistics().update(function);
    }

    private void addToDuration(long duration) {
        this.fDuration += duration;
    }

    private void addToCpuTime(long cpuTime) {
        if (cpuTime != -1L) {
            if (this.fCpuTime < 0L) {
                this.fCpuTime = 0L;
            }
            this.fCpuTime += cpuTime;
        }
    }

    public long getDuration() {
        return this.fDuration;
    }

    public long getNbCalls() {
        return this.fStatistics.getDurationStatistics().getNbElements();
    }

    public long getSelfTime() {
        return this.fSelfTime;
    }

    private void addToSelfTime(long selfTime) {
        this.fSelfTime += selfTime;
    }

    public long getCpuTime() {
        return this.fCpuTime;
    }

    public int getProcessId() {
        return this.fProcessId;
    }

    public void addKernelStatus(ProcessStatusInterval interval) {
        ProcessStatus processStatus = interval.getProcessStatus();
        AggregatedThreadStatus status = this.fProcessStatuses.get(processStatus);
        if (status == null) {
            status = new AggregatedThreadStatus(processStatus);
            this.fProcessStatuses.put(processStatus, status);
        }
        status.update(interval);
    }

    public @NonNull Collection<@NonNull WeightedTree<@NonNull ICallStackSymbol>> getExtraDataTrees(int index) {
        if (index == 0) {
            return ImmutableList.copyOf(this.fProcessStatuses.values());
        }
        return Collections.emptyList();
    }

    public @Nullable IStatistics<?> getStatistics(int metricIndex) {
        if (metricIndex < 0) {
            return this.getFunctionStatistics().getDurationStatistics();
        }
        if (metricIndex == 0) {
            return this.getFunctionStatistics().getSelfTimeStatistics();
        }
        if (metricIndex == 1) {
            return this.getFunctionStatistics().getCpuTimesStatistics();
        }
        return null;
    }

    public AggregatedCalledFunctionStatistics getFunctionStatistics() {
        return this.fStatistics;
    }

    public String toString() {
        return "Aggregate Function: " + String.valueOf(this.getObject()) + ", Duration: " + this.getDuration() + ", Self Time: " + this.fSelfTime + " on " + this.getNbCalls() + " calls";
    }
}

