/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionManagementException;
import org.eclipse.wst.xml.core.internal.document.XMLGeneratorImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifier;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifierImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelParser;
import org.eclipse.wst.xml.core.internal.document.XMLModelUpdater;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMModelImpl
extends AbstractStructuredModel
implements IStructuredDocumentListener,
IDOMModel,
DOMImplementation {
    private static String TRACE_PARSER_MANAGEMENT_EXCEPTION = "parserManagement";
    private Object active = null;
    private DocumentImpl document = (DocumentImpl)this.internalCreateDocument();
    private ISourceGenerator generator = null;
    private XMLModelNotifier notifier = null;
    private XMLModelParser parser = null;
    private boolean refresh = false;
    private XMLModelUpdater updater = null;

    public void aboutToChangeModel() {
        super.aboutToChangeModel();
        this.getModelNotifier().beginChanging();
    }

    public void aboutToReinitializeModel() {
        XMLModelNotifier notifier = this.getModelNotifier();
        notifier.cancelPending();
        super.aboutToReinitializeModel();
    }

    protected void attrReplaced(Element element, Attr newAttr, Attr oldAttr) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.replaceAttr(element, newAttr, oldAttr);
            this.setActive(null);
        }
        this.getModelNotifier().attrReplaced(element, newAttr, oldAttr);
    }

    public void changedModel() {
        if (this.isModelChangeStateOnVergeOfEnding()) {
            this.endLock();
            this.fLockObject = null;
            this.getModelNotifier().endChanging();
        }
        super.changedModel();
        this.handleRefresh();
    }

    protected void childReplaced(Node parentNode, Node newChild, Node oldChild) {
        if (parentNode == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.replaceChild(parentNode, newChild, oldChild);
            this.setActive(null);
        }
        this.getModelNotifier().childReplaced(parentNode, newChild, oldChild);
    }

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        DOMModelImpl model;
        DocumentImpl document = new DocumentImpl();
        if (namespaceURI == null && qualifiedName == null && doctype == null) {
            return document;
        }
        if (qualifiedName != null) {
            int idx = qualifiedName.indexOf(58);
            if (idx > 0) {
                if (namespaceURI == null) {
                    throw new DOMException(14, null);
                }
                String prefix = qualifiedName.substring(0, idx);
                if (prefix.equals("xml") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                    throw new DOMException(14, null);
                }
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(14, null);
                }
                String localName = qualifiedName.substring(idx + 1);
                int length = localName.length();
                if (length == 0) {
                    throw new DOMException(14, null);
                }
                switch (localName.charAt(0)) {
                    case '-': 
                    case '.': {
                        throw new DOMException(14, null);
                    }
                }
                int qualifiedLength = qualifiedName.length();
                int i = 0;
                while (i < qualifiedLength) {
                    char c = qualifiedName.charAt(i);
                    if (Character.isWhitespace(c)) {
                        throw new DOMException(5, null);
                    }
                    if (c == ':' && i != idx) {
                        throw new DOMException(14, null);
                    }
                    ++i;
                }
            }
            if (!NameValidator.isValid(qualifiedName)) {
                throw new DOMException(5, null);
            }
        } else if (namespaceURI != null) {
            throw new DOMException(14, null);
        }
        if ((model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML)) != null) {
            document.setModel(model);
            model.document = document;
        }
        if (doctype != null) {
            if (doctype.getOwnerDocument() != null) {
                throw new DOMException(4, null);
            }
            document.appendChild(doctype);
        }
        ElementImpl root = new ElementImpl();
        document.appendChild(root);
        root.setNamespaceURI(namespaceURI);
        root.setTagName(qualifiedName);
        return document;
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        DocumentTypeImpl documentType = new DocumentTypeImpl();
        documentType.setName(qualifiedName);
        documentType.setPublicId(publicId);
        documentType.setSystemId(systemId);
        return documentType;
    }

    protected void documentTypeChanged() {
        if (this.refresh) {
            return;
        }
        if (this.active != null || this.getModelNotifier().isChanging()) {
            return;
        }
        this.handleRefresh();
    }

    protected void editableChanged(Node node) {
        if (node != null) {
            this.getModelNotifier().editableChanged(node);
        }
    }

    protected void endTagChanged(Element element) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeEndTag(element);
            this.setActive(null);
        }
        this.getModelNotifier().endTagChanged(element);
    }

    private XMLModelParser getActiveParser() {
        if (this.parser == null) {
            return null;
        }
        if (this.parser != this.active) {
            return null;
        }
        return this.parser;
    }

    private XMLModelUpdater getActiveUpdater() {
        if (this.updater == null) {
            return null;
        }
        if (this.updater != this.active) {
            return null;
        }
        return this.updater;
    }

    public Object getAdapter(Class adapter) {
        if (Document.class.equals((Object)adapter)) {
            return this.getDocument();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IDOMDocument getDocument() {
        return this.document;
    }

    @Override
    public ISourceGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = XMLGeneratorImpl.getInstance();
        }
        return this.generator;
    }

    public IndexedRegion getIndexedRegion(int offset) {
        if (this.document == null) {
            return null;
        }
        IDOMNode parent = null;
        int length = this.document.getEndOffset();
        if (offset * 2 < length) {
            IDOMNode child = (IDOMNode)this.document.getFirstChild();
            while (child != null) {
                if (child.getEndOffset() <= offset) {
                    child = (IDOMNode)child.getNextSibling();
                    continue;
                }
                if (child.getStartOffset() <= offset) {
                    IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
                    if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                        return child;
                    }
                    IStructuredDocumentRegion endStructuredDocumentRegion = child.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.getStart() <= offset) {
                        return child;
                    }
                    parent = child;
                    child = (IDOMNode)parent.getFirstChild();
                    continue;
                }
                break;
            }
        } else {
            IDOMNode child = (IDOMNode)this.document.getLastChild();
            while (child != null) {
                if (child.getStartOffset() > offset) {
                    child = (IDOMNode)child.getPreviousSibling();
                    continue;
                }
                if (child.getEndOffset() > offset) {
                    IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
                    if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                        return child;
                    }
                    IStructuredDocumentRegion endStructuredDocumentRegion = child.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.getStart() <= offset) {
                        return child;
                    }
                    parent = child;
                    child = (IDOMNode)parent.getLastChild();
                    continue;
                }
                break;
            }
        }
        return parent;
    }

    @Override
    public XMLModelNotifier getModelNotifier() {
        if (this.notifier == null) {
            this.notifier = new XMLModelNotifierImpl();
        }
        return this.notifier;
    }

    private XMLModelParser getModelParser() {
        if (this.parser == null) {
            this.parser = this.createModelParser();
        }
        return this.parser;
    }

    protected XMLModelParser createModelParser() {
        return new XMLModelParser(this);
    }

    private XMLModelUpdater getModelUpdater() {
        if (this.updater == null) {
            this.updater = this.createModelUpdater();
        }
        return this.updater;
    }

    protected XMLModelUpdater createModelUpdater() {
        return new XMLModelUpdater(this);
    }

    private void handleRefresh() {
        if (!this.refresh) {
            return;
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging(true);
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        this.document.removeChildNodes();
        try {
            try {
                this.refresh = false;
                parser.replaceStructuredDocumentRegions(this.getStructuredDocument().getRegionList(), null);
            }
            catch (DOMException dOMException) {
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                }
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                }
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
            }
        }
    }

    @Override
    public boolean hasFeature(String feature, String version) {
        if (feature == null) {
            return false;
        }
        if (version != null && !version.equals("1.0") && !version.equals("2.0")) {
            return false;
        }
        if (feature.equalsIgnoreCase("Core")) {
            return true;
        }
        return feature.equalsIgnoreCase("XML");
    }

    protected Document internalCreateDocument() {
        DocumentImpl document = new DocumentImpl();
        document.setModel(this);
        return document;
    }

    boolean isReparsing() {
        return this.active != null;
    }

    protected void nameChanged(Node node) {
        if (node == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeName(node);
            this.setActive(null);
        }
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocument structuredDocument = structuredDocumentEvent.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (this.fStructuredDocument != null && this.fStructuredDocument != structuredDocument) {
            this.setStructuredDocument(structuredDocument);
        }
        this.internalSetNewDocument(structuredDocument);
    }

    private void internalSetNewDocument(IStructuredDocument structuredDocument) {
        if (structuredDocument == null) {
            return;
        }
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        if (flatNodes == null || flatNodes.getLength() == 0) {
            return;
        }
        if (this.document == null) {
            return;
        }
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(flatNodes, null);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        this.getModelNotifier().beginChanging(true);
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        this.document.removeChildNodes();
        try {
            try {
                parser.replaceStructuredDocumentRegions(flatNodes, null);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.setActive(null);
                if (!isChanging) {
                    this.getModelNotifier().endChanging();
                }
                this.refresh = false;
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                this.getModelNotifier().endChanging();
            }
            this.refresh = false;
        }
    }

    public void noChange(NoChangeEvent event) {
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(null, null);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegionList oldStructuredDocumentRegions = event.getOldStructuredDocumentRegions();
        IStructuredDocumentRegionList newStructuredDocumentRegions = event.getNewStructuredDocumentRegions();
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
                }
                catch (Exception ex) {
                    if (ex.getClass().equals(StructuredDocumentRegionManagementException.class)) {
                        Logger.traceException(TRACE_PARSER_MANAGEMENT_EXCEPTION, ex);
                    } else {
                        Logger.logException(ex);
                    }
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
            }
            catch (DOMException dOMException) {
                this.refresh = true;
                this.handleRefresh();
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
                this.handleRefresh();
            }
        }
    }

    public void regionChanged(RegionChangedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegion region = event.getRegion();
        if (region == null) {
            return;
        }
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.changeRegion(event, flatNode, region);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.changeRegion(event, flatNode, region);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
                this.handleRefresh();
            }
        }
    }

    public void regionsReplaced(RegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegionList oldRegions = event.getOldRegions();
        ITextRegionList newRegions = event.getNewRegions();
        if (oldRegions == null && newRegions == null) {
            return;
        }
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceRegions(flatNode, newRegions, oldRegions);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.replaceRegions(flatNode, newRegions, oldRegions);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
                this.handleRefresh();
            }
        }
    }

    public void releaseFromEdit() {
        this.isShared();
        super.releaseFromEdit();
    }

    public void releaseFromRead() {
        this.isShared();
        super.releaseFromRead();
    }

    private void setActive(Object active) {
        this.active = active;
        if (active == null) {
            this.document.activateTagNameCache(true);
        } else {
            this.document.activateTagNameCache(false);
        }
    }

    public void setGenerator(ISourceGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void setModelNotifier(XMLModelNotifier notifier) {
        this.notifier = notifier;
    }

    public void setModelParser(XMLModelParser parser) {
        this.parser = parser;
    }

    public void setModelUpdater(XMLModelUpdater updater) {
        this.updater = updater;
    }

    public void setStructuredDocument(IStructuredDocument structuredDocument) {
        IStructuredDocument oldStructuredDocument = super.getStructuredDocument();
        if (structuredDocument == oldStructuredDocument) {
            return;
        }
        if (oldStructuredDocument != null) {
            oldStructuredDocument.removeDocumentChangingListener((IStructuredDocumentListener)this);
        }
        super.setStructuredDocument(structuredDocument);
        if (structuredDocument != null) {
            this.internalSetNewDocument(structuredDocument);
            structuredDocument.addDocumentChangingListener((IStructuredDocumentListener)this);
        }
    }

    protected void startTagChanged(Element element) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeStartTag(element);
            this.setActive(null);
        }
        this.getModelNotifier().startTagChanged(element);
    }

    protected void valueChanged(Node node) {
        if (node == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeValue(node);
            this.setActive(null);
        }
        this.getModelNotifier().valueChanged(node);
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new DOMException(9, "Not implemented in this version.");
    }
}

